package org.graylog2.indexer.searches;

import java.util.List;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.OptionalLong;
import java.util.Set;
import javax.annotation.Generated;
import javax.annotation.Nullable;
import org.graylog2.plugin.indexer.searches.timeranges.TimeRange;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
final class AutoValue_ScrollCommand extends ScrollCommand {

  private final String query;

  private final Set<String> indices;

  private final Optional<Set<String>> streams;

  private final Optional<Sorting> sorting;

  private final Optional<String> filter;

  private final Optional<TimeRange> range;

  private final OptionalInt limit;

  private final OptionalInt offset;

  private final List<String> fields;

  private final OptionalLong batchSize;

  private final boolean highlight;

  private AutoValue_ScrollCommand(
      String query,
      Set<String> indices,
      Optional<Set<String>> streams,
      Optional<Sorting> sorting,
      Optional<String> filter,
      Optional<TimeRange> range,
      OptionalInt limit,
      OptionalInt offset,
      List<String> fields,
      OptionalLong batchSize,
      boolean highlight) {
    this.query = query;
    this.indices = indices;
    this.streams = streams;
    this.sorting = sorting;
    this.filter = filter;
    this.range = range;
    this.limit = limit;
    this.offset = offset;
    this.fields = fields;
    this.batchSize = batchSize;
    this.highlight = highlight;
  }

  @Override
  public String query() {
    return query;
  }

  @Override
  public Set<String> indices() {
    return indices;
  }

  @Override
  public Optional<Set<String>> streams() {
    return streams;
  }

  @Override
  public Optional<Sorting> sorting() {
    return sorting;
  }

  @Override
  public Optional<String> filter() {
    return filter;
  }

  @Override
  public Optional<TimeRange> range() {
    return range;
  }

  @Override
  public OptionalInt limit() {
    return limit;
  }

  @Override
  public OptionalInt offset() {
    return offset;
  }

  @Override
  public List<String> fields() {
    return fields;
  }

  @Override
  public OptionalLong batchSize() {
    return batchSize;
  }

  @Override
  public boolean highlight() {
    return highlight;
  }

  @Override
  public String toString() {
    return "ScrollCommand{"
        + "query=" + query + ", "
        + "indices=" + indices + ", "
        + "streams=" + streams + ", "
        + "sorting=" + sorting + ", "
        + "filter=" + filter + ", "
        + "range=" + range + ", "
        + "limit=" + limit + ", "
        + "offset=" + offset + ", "
        + "fields=" + fields + ", "
        + "batchSize=" + batchSize + ", "
        + "highlight=" + highlight
        + "}";
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof ScrollCommand) {
      ScrollCommand that = (ScrollCommand) o;
      return this.query.equals(that.query())
          && this.indices.equals(that.indices())
          && this.streams.equals(that.streams())
          && this.sorting.equals(that.sorting())
          && this.filter.equals(that.filter())
          && this.range.equals(that.range())
          && this.limit.equals(that.limit())
          && this.offset.equals(that.offset())
          && this.fields.equals(that.fields())
          && this.batchSize.equals(that.batchSize())
          && this.highlight == that.highlight();
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h$ = 1;
    h$ *= 1000003;
    h$ ^= query.hashCode();
    h$ *= 1000003;
    h$ ^= indices.hashCode();
    h$ *= 1000003;
    h$ ^= streams.hashCode();
    h$ *= 1000003;
    h$ ^= sorting.hashCode();
    h$ *= 1000003;
    h$ ^= filter.hashCode();
    h$ *= 1000003;
    h$ ^= range.hashCode();
    h$ *= 1000003;
    h$ ^= limit.hashCode();
    h$ *= 1000003;
    h$ ^= offset.hashCode();
    h$ *= 1000003;
    h$ ^= fields.hashCode();
    h$ *= 1000003;
    h$ ^= batchSize.hashCode();
    h$ *= 1000003;
    h$ ^= highlight ? 1231 : 1237;
    return h$;
  }

  static final class Builder extends ScrollCommand.Builder {
    private String query;
    private Set<String> indices;
    private Optional<Set<String>> streams = Optional.empty();
    private Optional<Sorting> sorting = Optional.empty();
    private Optional<String> filter = Optional.empty();
    private Optional<TimeRange> range = Optional.empty();
    private OptionalInt limit = OptionalInt.empty();
    private OptionalInt offset = OptionalInt.empty();
    private List<String> fields;
    private OptionalLong batchSize = OptionalLong.empty();
    private Boolean highlight;
    Builder() {
    }
    @Override
    public ScrollCommand.Builder query(String query) {
      if (query == null) {
        throw new NullPointerException("Null query");
      }
      this.query = query;
      return this;
    }
    @Override
    public ScrollCommand.Builder indices(Set<String> indices) {
      if (indices == null) {
        throw new NullPointerException("Null indices");
      }
      this.indices = indices;
      return this;
    }
    @Override
    public ScrollCommand.Builder streams(Set<String> streams) {
      this.streams = Optional.of(streams);
      return this;
    }
    @Override
    public ScrollCommand.Builder sorting(Sorting sorting) {
      this.sorting = Optional.of(sorting);
      return this;
    }
    @Override
    public ScrollCommand.Builder filter(@Nullable String filter) {
      this.filter = Optional.ofNullable(filter);
      return this;
    }
    @Override
    public ScrollCommand.Builder range(TimeRange range) {
      this.range = Optional.of(range);
      return this;
    }
    @Override
    public ScrollCommand.Builder limit(int limit) {
      this.limit = OptionalInt.of(limit);
      return this;
    }
    @Override
    public ScrollCommand.Builder offset(int offset) {
      this.offset = OptionalInt.of(offset);
      return this;
    }
    @Override
    public ScrollCommand.Builder fields(List<String> fields) {
      if (fields == null) {
        throw new NullPointerException("Null fields");
      }
      this.fields = fields;
      return this;
    }
    @Override
    public ScrollCommand.Builder batchSize(int batchSize) {
      this.batchSize = OptionalLong.of(batchSize);
      return this;
    }
    @Override
    public ScrollCommand.Builder highlight(boolean highlight) {
      this.highlight = highlight;
      return this;
    }
    @Override
    public ScrollCommand build() {
      String missing = "";
      if (this.query == null) {
        missing += " query";
      }
      if (this.indices == null) {
        missing += " indices";
      }
      if (this.fields == null) {
        missing += " fields";
      }
      if (this.highlight == null) {
        missing += " highlight";
      }
      if (!missing.isEmpty()) {
        throw new IllegalStateException("Missing required properties:" + missing);
      }
      return new AutoValue_ScrollCommand(
          this.query,
          this.indices,
          this.streams,
          this.sorting,
          this.filter,
          this.range,
          this.limit,
          this.offset,
          this.fields,
          this.batchSize,
          this.highlight);
    }
  }

}
