package org.graylog2.inputs.persistence;

import com.fasterxml.jackson.annotation.JsonProperty;
import javax.annotation.Generated;
import org.mongojack.Id;
import org.mongojack.ObjectId;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
final class AutoValue_InputStatusRecord extends InputStatusRecord {

  private final String inputId;

  private final InputStateData inputStateData;

  private AutoValue_InputStatusRecord(
      String inputId,
      InputStateData inputStateData) {
    this.inputId = inputId;
    this.inputStateData = inputStateData;
  }

  @Id
  @ObjectId
  @JsonProperty("id")
  @Override
  public String inputId() {
    return inputId;
  }

  @JsonProperty("input_state_data")
  @Override
  public InputStateData inputStateData() {
    return inputStateData;
  }

  @Override
  public String toString() {
    return "InputStatusRecord{"
        + "inputId=" + inputId + ", "
        + "inputStateData=" + inputStateData
        + "}";
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof InputStatusRecord) {
      InputStatusRecord that = (InputStatusRecord) o;
      return this.inputId.equals(that.inputId())
          && this.inputStateData.equals(that.inputStateData());
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h$ = 1;
    h$ *= 1000003;
    h$ ^= inputId.hashCode();
    h$ *= 1000003;
    h$ ^= inputStateData.hashCode();
    return h$;
  }

  static final class Builder extends InputStatusRecord.Builder {
    private String inputId;
    private InputStateData inputStateData;
    Builder() {
    }
    @Override
    public InputStatusRecord.Builder inputId(String inputId) {
      if (inputId == null) {
        throw new NullPointerException("Null inputId");
      }
      this.inputId = inputId;
      return this;
    }
    @Override
    public InputStatusRecord.Builder inputStateData(InputStateData inputStateData) {
      if (inputStateData == null) {
        throw new NullPointerException("Null inputStateData");
      }
      this.inputStateData = inputStateData;
      return this;
    }
    @Override
    public InputStatusRecord build() {
      String missing = "";
      if (this.inputId == null) {
        missing += " inputId";
      }
      if (this.inputStateData == null) {
        missing += " inputStateData";
      }
      if (!missing.isEmpty()) {
        throw new IllegalStateException("Missing required properties:" + missing);
      }
      return new AutoValue_InputStatusRecord(
          this.inputId,
          this.inputStateData);
    }
  }

}
