package org.graylog2.lookup.adapters;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Optional;
import javax.annotation.Generated;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.Size;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
abstract class $AutoValue_CSVFileDataAdapter_Config extends CSVFileDataAdapter.Config {

  private final String type;

  private final @NotEmpty String path;

  private final @Size(min = 1, max = 1) @NotEmpty String separator;

  private final @Size(min = 1, max = 1) @NotEmpty String quotechar;

  private final @NotEmpty String keyColumn;

  private final @NotEmpty String valueColumn;

  private final @Min(1L) long checkInterval;

  private final Optional<Boolean> caseInsensitiveLookup;

  $AutoValue_CSVFileDataAdapter_Config(
      String type,
      @NotEmpty String path,
      @Size(min = 1, max = 1) @NotEmpty String separator,
      @Size(min = 1, max = 1) @NotEmpty String quotechar,
      @NotEmpty String keyColumn,
      @NotEmpty String valueColumn,
      @Min(1L) long checkInterval,
      Optional<Boolean> caseInsensitiveLookup) {
    if (type == null) {
      throw new NullPointerException("Null type");
    }
    this.type = type;
    if (path == null) {
      throw new NullPointerException("Null path");
    }
    this.path = path;
    if (separator == null) {
      throw new NullPointerException("Null separator");
    }
    this.separator = separator;
    if (quotechar == null) {
      throw new NullPointerException("Null quotechar");
    }
    this.quotechar = quotechar;
    if (keyColumn == null) {
      throw new NullPointerException("Null keyColumn");
    }
    this.keyColumn = keyColumn;
    if (valueColumn == null) {
      throw new NullPointerException("Null valueColumn");
    }
    this.valueColumn = valueColumn;
    this.checkInterval = checkInterval;
    if (caseInsensitiveLookup == null) {
      throw new NullPointerException("Null caseInsensitiveLookup");
    }
    this.caseInsensitiveLookup = caseInsensitiveLookup;
  }

  @JsonProperty("type")
  @Override
  public String type() {
    return type;
  }

  @JsonProperty("path")
  @Override
  public @NotEmpty String path() {
    return path;
  }

  @JsonProperty("separator")
  @Override
  public @Size(min = 1, max = 1) @NotEmpty String separator() {
    return separator;
  }

  @JsonProperty("quotechar")
  @Override
  public @Size(min = 1, max = 1) @NotEmpty String quotechar() {
    return quotechar;
  }

  @JsonProperty("key_column")
  @Override
  public @NotEmpty String keyColumn() {
    return keyColumn;
  }

  @JsonProperty("value_column")
  @Override
  public @NotEmpty String valueColumn() {
    return valueColumn;
  }

  @JsonProperty("check_interval")
  @Override
  public @Min(1L) long checkInterval() {
    return checkInterval;
  }

  @JsonProperty("case_insensitive_lookup")
  @Override
  public Optional<Boolean> caseInsensitiveLookup() {
    return caseInsensitiveLookup;
  }

  @Override
  public String toString() {
    return "Config{"
        + "type=" + type + ", "
        + "path=" + path + ", "
        + "separator=" + separator + ", "
        + "quotechar=" + quotechar + ", "
        + "keyColumn=" + keyColumn + ", "
        + "valueColumn=" + valueColumn + ", "
        + "checkInterval=" + checkInterval + ", "
        + "caseInsensitiveLookup=" + caseInsensitiveLookup
        + "}";
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof CSVFileDataAdapter.Config) {
      CSVFileDataAdapter.Config that = (CSVFileDataAdapter.Config) o;
      return this.type.equals(that.type())
          && this.path.equals(that.path())
          && this.separator.equals(that.separator())
          && this.quotechar.equals(that.quotechar())
          && this.keyColumn.equals(that.keyColumn())
          && this.valueColumn.equals(that.valueColumn())
          && this.checkInterval == that.checkInterval()
          && this.caseInsensitiveLookup.equals(that.caseInsensitiveLookup());
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h$ = 1;
    h$ *= 1000003;
    h$ ^= type.hashCode();
    h$ *= 1000003;
    h$ ^= path.hashCode();
    h$ *= 1000003;
    h$ ^= separator.hashCode();
    h$ *= 1000003;
    h$ ^= quotechar.hashCode();
    h$ *= 1000003;
    h$ ^= keyColumn.hashCode();
    h$ *= 1000003;
    h$ ^= valueColumn.hashCode();
    h$ *= 1000003;
    h$ ^= (int) ((checkInterval >>> 32) ^ checkInterval);
    h$ *= 1000003;
    h$ ^= caseInsensitiveLookup.hashCode();
    return h$;
  }

  static class Builder extends CSVFileDataAdapter.Config.Builder {
    private String type;
    private @NotEmpty String path;
    private @Size(min = 1, max = 1) @NotEmpty String separator;
    private @Size(min = 1, max = 1) @NotEmpty String quotechar;
    private @NotEmpty String keyColumn;
    private @NotEmpty String valueColumn;
    private Long checkInterval;
    private Optional<Boolean> caseInsensitiveLookup = Optional.empty();
    Builder() {
    }
    @Override
    public CSVFileDataAdapter.Config.Builder type(String type) {
      if (type == null) {
        throw new NullPointerException("Null type");
      }
      this.type = type;
      return this;
    }
    @Override
    public CSVFileDataAdapter.Config.Builder path(String path) {
      if (path == null) {
        throw new NullPointerException("Null path");
      }
      this.path = path;
      return this;
    }
    @Override
    public CSVFileDataAdapter.Config.Builder separator(String separator) {
      if (separator == null) {
        throw new NullPointerException("Null separator");
      }
      this.separator = separator;
      return this;
    }
    @Override
    public CSVFileDataAdapter.Config.Builder quotechar(String quotechar) {
      if (quotechar == null) {
        throw new NullPointerException("Null quotechar");
      }
      this.quotechar = quotechar;
      return this;
    }
    @Override
    public CSVFileDataAdapter.Config.Builder keyColumn(String keyColumn) {
      if (keyColumn == null) {
        throw new NullPointerException("Null keyColumn");
      }
      this.keyColumn = keyColumn;
      return this;
    }
    @Override
    public CSVFileDataAdapter.Config.Builder valueColumn(String valueColumn) {
      if (valueColumn == null) {
        throw new NullPointerException("Null valueColumn");
      }
      this.valueColumn = valueColumn;
      return this;
    }
    @Override
    public CSVFileDataAdapter.Config.Builder checkInterval(long checkInterval) {
      this.checkInterval = checkInterval;
      return this;
    }
    @Override
    public CSVFileDataAdapter.Config.Builder caseInsensitiveLookup(Boolean caseInsensitiveLookup) {
      this.caseInsensitiveLookup = Optional.of(caseInsensitiveLookup);
      return this;
    }
    @Override
    public CSVFileDataAdapter.Config build() {
      String missing = "";
      if (this.type == null) {
        missing += " type";
      }
      if (this.path == null) {
        missing += " path";
      }
      if (this.separator == null) {
        missing += " separator";
      }
      if (this.quotechar == null) {
        missing += " quotechar";
      }
      if (this.keyColumn == null) {
        missing += " keyColumn";
      }
      if (this.valueColumn == null) {
        missing += " valueColumn";
      }
      if (this.checkInterval == null) {
        missing += " checkInterval";
      }
      if (!missing.isEmpty()) {
        throw new IllegalStateException("Missing required properties:" + missing);
      }
      return new AutoValue_CSVFileDataAdapter_Config(
          this.type,
          this.path,
          this.separator,
          this.quotechar,
          this.keyColumn,
          this.valueColumn,
          this.checkInterval,
          this.caseInsensitiveLookup);
    }
  }

}
