package org.graylog2.lookup.adapters;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.concurrent.TimeUnit;
import javax.annotation.Generated;
import javax.annotation.Nullable;
import org.graylog2.lookup.adapters.dnslookup.DnsLookupType;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
abstract class $AutoValue_DnsLookupDataAdapter_Config extends DnsLookupDataAdapter.Config {

  private final String type;

  private final DnsLookupType lookupType;

  private final String serverIps;

  private final int requestTimeout;

  private final boolean cacheTTLOverrideEnabled;

  private final Long cacheTTLOverride;

  private final TimeUnit cacheTTLOverrideUnit;

  $AutoValue_DnsLookupDataAdapter_Config(
      String type,
      DnsLookupType lookupType,
      String serverIps,
      int requestTimeout,
      boolean cacheTTLOverrideEnabled,
      @Nullable Long cacheTTLOverride,
      @Nullable TimeUnit cacheTTLOverrideUnit) {
    if (type == null) {
      throw new NullPointerException("Null type");
    }
    this.type = type;
    if (lookupType == null) {
      throw new NullPointerException("Null lookupType");
    }
    this.lookupType = lookupType;
    if (serverIps == null) {
      throw new NullPointerException("Null serverIps");
    }
    this.serverIps = serverIps;
    this.requestTimeout = requestTimeout;
    this.cacheTTLOverrideEnabled = cacheTTLOverrideEnabled;
    this.cacheTTLOverride = cacheTTLOverride;
    this.cacheTTLOverrideUnit = cacheTTLOverrideUnit;
  }

  @JsonProperty("type")
  @Override
  public String type() {
    return type;
  }

  @JsonProperty("lookup_type")
  @Override
  public DnsLookupType lookupType() {
    return lookupType;
  }

  @JsonProperty("server_ips")
  @Override
  public String serverIps() {
    return serverIps;
  }

  @JsonProperty("request_timeout")
  @Override
  public int requestTimeout() {
    return requestTimeout;
  }

  @JsonProperty("cache_ttl_override_enabled")
  @Override
  public boolean cacheTTLOverrideEnabled() {
    return cacheTTLOverrideEnabled;
  }

  @Nullable
  @JsonProperty("cache_ttl_override")
  @Override
  public Long cacheTTLOverride() {
    return cacheTTLOverride;
  }

  @Nullable
  @JsonProperty("cache_ttl_override_unit")
  @Override
  public TimeUnit cacheTTLOverrideUnit() {
    return cacheTTLOverrideUnit;
  }

  @Override
  public String toString() {
    return "Config{"
        + "type=" + type + ", "
        + "lookupType=" + lookupType + ", "
        + "serverIps=" + serverIps + ", "
        + "requestTimeout=" + requestTimeout + ", "
        + "cacheTTLOverrideEnabled=" + cacheTTLOverrideEnabled + ", "
        + "cacheTTLOverride=" + cacheTTLOverride + ", "
        + "cacheTTLOverrideUnit=" + cacheTTLOverrideUnit
        + "}";
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof DnsLookupDataAdapter.Config) {
      DnsLookupDataAdapter.Config that = (DnsLookupDataAdapter.Config) o;
      return this.type.equals(that.type())
          && this.lookupType.equals(that.lookupType())
          && this.serverIps.equals(that.serverIps())
          && this.requestTimeout == that.requestTimeout()
          && this.cacheTTLOverrideEnabled == that.cacheTTLOverrideEnabled()
          && (this.cacheTTLOverride == null ? that.cacheTTLOverride() == null : this.cacheTTLOverride.equals(that.cacheTTLOverride()))
          && (this.cacheTTLOverrideUnit == null ? that.cacheTTLOverrideUnit() == null : this.cacheTTLOverrideUnit.equals(that.cacheTTLOverrideUnit()));
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h$ = 1;
    h$ *= 1000003;
    h$ ^= type.hashCode();
    h$ *= 1000003;
    h$ ^= lookupType.hashCode();
    h$ *= 1000003;
    h$ ^= serverIps.hashCode();
    h$ *= 1000003;
    h$ ^= requestTimeout;
    h$ *= 1000003;
    h$ ^= cacheTTLOverrideEnabled ? 1231 : 1237;
    h$ *= 1000003;
    h$ ^= (cacheTTLOverride == null) ? 0 : cacheTTLOverride.hashCode();
    h$ *= 1000003;
    h$ ^= (cacheTTLOverrideUnit == null) ? 0 : cacheTTLOverrideUnit.hashCode();
    return h$;
  }

  static class Builder extends DnsLookupDataAdapter.Config.Builder {
    private String type;
    private DnsLookupType lookupType;
    private String serverIps;
    private Integer requestTimeout;
    private Boolean cacheTTLOverrideEnabled;
    private Long cacheTTLOverride;
    private TimeUnit cacheTTLOverrideUnit;
    Builder() {
    }
    @Override
    public DnsLookupDataAdapter.Config.Builder type(String type) {
      if (type == null) {
        throw new NullPointerException("Null type");
      }
      this.type = type;
      return this;
    }
    @Override
    public DnsLookupDataAdapter.Config.Builder lookupType(DnsLookupType lookupType) {
      if (lookupType == null) {
        throw new NullPointerException("Null lookupType");
      }
      this.lookupType = lookupType;
      return this;
    }
    @Override
    public DnsLookupDataAdapter.Config.Builder serverIps(String serverIps) {
      if (serverIps == null) {
        throw new NullPointerException("Null serverIps");
      }
      this.serverIps = serverIps;
      return this;
    }
    @Override
    public DnsLookupDataAdapter.Config.Builder requestTimeout(int requestTimeout) {
      this.requestTimeout = requestTimeout;
      return this;
    }
    @Override
    public DnsLookupDataAdapter.Config.Builder cacheTTLOverrideEnabled(boolean cacheTTLOverrideEnabled) {
      this.cacheTTLOverrideEnabled = cacheTTLOverrideEnabled;
      return this;
    }
    @Override
    public DnsLookupDataAdapter.Config.Builder cacheTTLOverride(Long cacheTTLOverride) {
      this.cacheTTLOverride = cacheTTLOverride;
      return this;
    }
    @Override
    public DnsLookupDataAdapter.Config.Builder cacheTTLOverrideUnit(@Nullable TimeUnit cacheTTLOverrideUnit) {
      this.cacheTTLOverrideUnit = cacheTTLOverrideUnit;
      return this;
    }
    @Override
    DnsLookupDataAdapter.Config autoBuild() {
      String missing = "";
      if (this.type == null) {
        missing += " type";
      }
      if (this.lookupType == null) {
        missing += " lookupType";
      }
      if (this.serverIps == null) {
        missing += " serverIps";
      }
      if (this.requestTimeout == null) {
        missing += " requestTimeout";
      }
      if (this.cacheTTLOverrideEnabled == null) {
        missing += " cacheTTLOverrideEnabled";
      }
      if (!missing.isEmpty()) {
        throw new IllegalStateException("Missing required properties:" + missing);
      }
      return new AutoValue_DnsLookupDataAdapter_Config(
          this.type,
          this.lookupType,
          this.serverIps,
          this.requestTimeout,
          this.cacheTTLOverrideEnabled,
          this.cacheTTLOverride,
          this.cacheTTLOverrideUnit);
    }
  }

}
