package org.graylog2.lookup.adapters;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.lang.String;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.validation.constraints.NotEmpty;

final class AutoValue_HTTPJSONPathDataAdapter_Config extends $AutoValue_HTTPJSONPathDataAdapter_Config {
  AutoValue_HTTPJSONPathDataAdapter_Config(String type, String url, String singleValueJSONPath,
      Optional<String> multiValueJSONPath, String userAgent, Map<String, String> headers) {
    super(type, url, singleValueJSONPath, multiValueJSONPath, userAgent, headers);
  }

  @JsonIgnore
  public final String getType() {
    return type();
  }

  @JsonIgnore
  @NotEmpty
  public final String getUrl() {
    return url();
  }

  @JsonIgnore
  @NotEmpty
  public final String getSingleValueJSONPath() {
    return singleValueJSONPath();
  }

  @JsonIgnore
  public final Optional<String> getMultiValueJSONPath() {
    return multiValueJSONPath();
  }

  @JsonIgnore
  @NotEmpty
  public final String getUserAgent() {
    return userAgent();
  }

  @JsonIgnore
  @Nullable
  public final Map<String, String> getHeaders() {
    return headers();
  }
}
