package org.graylog2.lookup.adapters.dnslookup;

import com.fasterxml.jackson.annotation.JsonProperty;
import javax.annotation.Generated;
import javax.annotation.Nullable;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
abstract class $AutoValue_ADnsAnswer extends ADnsAnswer {

  private final String ipAddress;

  private final String ipVersion;

  private final long dnsTTL;

  $AutoValue_ADnsAnswer(
      String ipAddress,
      @Nullable String ipVersion,
      long dnsTTL) {
    if (ipAddress == null) {
      throw new NullPointerException("Null ipAddress");
    }
    this.ipAddress = ipAddress;
    this.ipVersion = ipVersion;
    this.dnsTTL = dnsTTL;
  }

  @JsonProperty("ip_address")
  @Override
  public String ipAddress() {
    return ipAddress;
  }

  @Nullable
  @JsonProperty("ip_version")
  @Override
  public String ipVersion() {
    return ipVersion;
  }

  @JsonProperty("dns_ttl")
  @Override
  public long dnsTTL() {
    return dnsTTL;
  }

  @Override
  public String toString() {
    return "ADnsAnswer{"
        + "ipAddress=" + ipAddress + ", "
        + "ipVersion=" + ipVersion + ", "
        + "dnsTTL=" + dnsTTL
        + "}";
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof ADnsAnswer) {
      ADnsAnswer that = (ADnsAnswer) o;
      return this.ipAddress.equals(that.ipAddress())
          && (this.ipVersion == null ? that.ipVersion() == null : this.ipVersion.equals(that.ipVersion()))
          && this.dnsTTL == that.dnsTTL();
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h$ = 1;
    h$ *= 1000003;
    h$ ^= ipAddress.hashCode();
    h$ *= 1000003;
    h$ ^= (ipVersion == null) ? 0 : ipVersion.hashCode();
    h$ *= 1000003;
    h$ ^= (int) ((dnsTTL >>> 32) ^ dnsTTL);
    return h$;
  }

  static class Builder extends ADnsAnswer.Builder {
    private String ipAddress;
    private String ipVersion;
    private Long dnsTTL;
    Builder() {
    }
    @Override
    public ADnsAnswer.Builder ipAddress(String ipAddress) {
      if (ipAddress == null) {
        throw new NullPointerException("Null ipAddress");
      }
      this.ipAddress = ipAddress;
      return this;
    }
    @Override
    public ADnsAnswer.Builder ipVersion(String ipVersion) {
      this.ipVersion = ipVersion;
      return this;
    }
    @Override
    public ADnsAnswer.Builder dnsTTL(long dnsTTL) {
      this.dnsTTL = dnsTTL;
      return this;
    }
    @Override
    ADnsAnswer autoBuild() {
      String missing = "";
      if (this.ipAddress == null) {
        missing += " ipAddress";
      }
      if (this.dnsTTL == null) {
        missing += " dnsTTL";
      }
      if (!missing.isEmpty()) {
        throw new IllegalStateException("Missing required properties:" + missing);
      }
      return new AutoValue_ADnsAnswer(
          this.ipAddress,
          this.ipVersion,
          this.dnsTTL);
    }
  }

}
