package org.graylog2.lookup.dto;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.lang.Boolean;
import java.lang.Long;
import java.lang.String;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import org.graylog2.plugin.lookup.LookupDataAdapterConfiguration;
import org.mongojack.Id;
import org.mongojack.ObjectId;

final class AutoValue_DataAdapterDto extends $AutoValue_DataAdapterDto {
  AutoValue_DataAdapterDto(String id, String title, String description, String name,
      Boolean customErrorTTLEnabled, Long customErrorTTL, TimeUnit customErrorTTLUnit,
      String contentPack, LookupDataAdapterConfiguration config) {
    super(id, title, description, name, customErrorTTLEnabled, customErrorTTL, customErrorTTLUnit, contentPack, config);
  }

  @JsonIgnore
  @Id
  @ObjectId
  @Nullable
  public final String getId() {
    return id();
  }

  @JsonIgnore
  public final String getTitle() {
    return title();
  }

  @JsonIgnore
  public final String getDescription() {
    return description();
  }

  @JsonIgnore
  public final String getName() {
    return name();
  }

  @JsonIgnore
  @Nullable
  public final Boolean isCustomErrorTTLEnabled() {
    return customErrorTTLEnabled();
  }

  @JsonIgnore
  @Nullable
  public final Long getCustomErrorTTL() {
    return customErrorTTL();
  }

  @JsonIgnore
  @Nullable
  public final TimeUnit getCustomErrorTTLUnit() {
    return customErrorTTLUnit();
  }

  @JsonIgnore
  @Nullable
  public final String getContentPack() {
    return contentPack();
  }

  @JsonIgnore
  public final LookupDataAdapterConfiguration getConfig() {
    return config();
  }
}
