package org.graylog2.rest.models.users.responses;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import java.lang.Long;
import java.lang.Object;
import java.lang.String;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.shiro.authz.permission.WildcardPermission;
import org.graylog.security.permissions.GRNPermission;
import org.graylog2.plugin.database.users.User;
import org.graylog2.rest.models.users.requests.Startpage;

final class AutoValue_UserSummary extends $AutoValue_UserSummary {
  AutoValue_UserSummary(String id, String username, String email, String firstName, String lastName,
      String fullName, List<WildcardPermission> permissions, List<GRNPermission> grnPermissions,
      Map<String, Object> preferences, String timezone, Long sessionTimeoutMs, boolean readOnly,
      boolean external, Startpage startpage, Set<String> roles, boolean sessionActive,
      Date lastActivity, String clientAddress, User.AccountStatus accountStatus) {
    super(id, username, email, firstName, lastName, fullName, permissions, grnPermissions, preferences, timezone, sessionTimeoutMs, readOnly, external, startpage, roles, sessionActive, lastActivity, clientAddress, accountStatus);
  }

  @JsonIgnore
  @Nullable
  public final String getId() {
    return id();
  }

  @JsonIgnore
  public final String getUsername() {
    return username();
  }

  @JsonIgnore
  public final String getEmail() {
    return email();
  }

  @JsonIgnore
  @Nullable
  public final String getFirstName() {
    return firstName();
  }

  @JsonIgnore
  @Nullable
  public final String getLastName() {
    return lastName();
  }

  @JsonIgnore
  @Nullable
  public final String getFullName() {
    return fullName();
  }

  @JsonIgnore
  @JsonSerialize(
      contentUsing = ToStringSerializer.class
  )
  public final List<WildcardPermission> getPermissions() {
    return permissions();
  }

  @JsonIgnore
  public final List<GRNPermission> getGrnPermissions() {
    return grnPermissions();
  }

  @JsonIgnore
  @Nullable
  public final Map<String, Object> getPreferences() {
    return preferences();
  }

  @JsonIgnore
  @Nullable
  public final String getTimezone() {
    return timezone();
  }

  @JsonIgnore
  @Nullable
  public final Long getSessionTimeoutMs() {
    return sessionTimeoutMs();
  }

  @JsonIgnore
  public final boolean isReadOnly() {
    return readOnly();
  }

  @JsonIgnore
  public final boolean isExternal() {
    return external();
  }

  @JsonIgnore
  @Nullable
  public final Startpage getStartpage() {
    return startpage();
  }

  @JsonIgnore
  @Nullable
  public final Set<String> getRoles() {
    return roles();
  }

  @JsonIgnore
  public final boolean isSessionActive() {
    return sessionActive();
  }

  @JsonIgnore
  @Nullable
  public final Date getLastActivity() {
    return lastActivity();
  }

  @JsonIgnore
  @Nullable
  public final String getClientAddress() {
    return clientAddress();
  }

  @JsonIgnore
  public final User.AccountStatus getAccountStatus() {
    return accountStatus();
  }
}
