package org.graylog2.rest.resources.system.indexer.responses;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.ZonedDateTime;
import java.util.Optional;
import javax.annotation.Generated;
import javax.annotation.Nullable;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import org.graylog2.indexer.indexset.IndexSetConfig;
import org.graylog2.plugin.indexer.retention.RetentionStrategyConfig;
import org.graylog2.plugin.indexer.rotation.RotationStrategyConfig;
import org.joda.time.Duration;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
abstract class $AutoValue_IndexSetSummary extends IndexSetSummary {

  private final String id;

  private final @NotBlank String title;

  private final String description;

  private final boolean isDefault;

  private final boolean isWritable;

  private final @Pattern(regexp = "^[a-z0-9][a-z0-9_+-]*$") String indexPrefix;

  private final @Min(1L) int shards;

  private final @Min(0L) int replicas;

  private final @NotNull String rotationStrategyClass;

  private final @NotNull RotationStrategyConfig rotationStrategy;

  private final @NotNull String retentionStrategyClass;

  private final @NotNull RetentionStrategyConfig retentionStrategy;

  private final @NotNull ZonedDateTime creationDate;

  private final @NotBlank String indexAnalyzer;

  private final @Min(1L) int indexOptimizationMaxNumSegments;

  private final boolean indexOptimizationDisabled;

  private final Duration fieldTypeRefreshInterval;

  private final Optional<IndexSetConfig.TemplateType> templateType;

  $AutoValue_IndexSetSummary(
      @Nullable String id,
      @NotBlank String title,
      @Nullable String description,
      boolean isDefault,
      boolean isWritable,
      @Pattern(regexp = "^[a-z0-9][a-z0-9_+-]*$") String indexPrefix,
      @Min(1L) int shards,
      @Min(0L) int replicas,
      @NotNull String rotationStrategyClass,
      @NotNull RotationStrategyConfig rotationStrategy,
      @NotNull String retentionStrategyClass,
      @NotNull RetentionStrategyConfig retentionStrategy,
      @NotNull ZonedDateTime creationDate,
      @NotBlank String indexAnalyzer,
      @Min(1L) int indexOptimizationMaxNumSegments,
      boolean indexOptimizationDisabled,
      Duration fieldTypeRefreshInterval,
      Optional<IndexSetConfig.TemplateType> templateType) {
    this.id = id;
    if (title == null) {
      throw new NullPointerException("Null title");
    }
    this.title = title;
    this.description = description;
    this.isDefault = isDefault;
    this.isWritable = isWritable;
    if (indexPrefix == null) {
      throw new NullPointerException("Null indexPrefix");
    }
    this.indexPrefix = indexPrefix;
    this.shards = shards;
    this.replicas = replicas;
    if (rotationStrategyClass == null) {
      throw new NullPointerException("Null rotationStrategyClass");
    }
    this.rotationStrategyClass = rotationStrategyClass;
    if (rotationStrategy == null) {
      throw new NullPointerException("Null rotationStrategy");
    }
    this.rotationStrategy = rotationStrategy;
    if (retentionStrategyClass == null) {
      throw new NullPointerException("Null retentionStrategyClass");
    }
    this.retentionStrategyClass = retentionStrategyClass;
    if (retentionStrategy == null) {
      throw new NullPointerException("Null retentionStrategy");
    }
    this.retentionStrategy = retentionStrategy;
    if (creationDate == null) {
      throw new NullPointerException("Null creationDate");
    }
    this.creationDate = creationDate;
    if (indexAnalyzer == null) {
      throw new NullPointerException("Null indexAnalyzer");
    }
    this.indexAnalyzer = indexAnalyzer;
    this.indexOptimizationMaxNumSegments = indexOptimizationMaxNumSegments;
    this.indexOptimizationDisabled = indexOptimizationDisabled;
    if (fieldTypeRefreshInterval == null) {
      throw new NullPointerException("Null fieldTypeRefreshInterval");
    }
    this.fieldTypeRefreshInterval = fieldTypeRefreshInterval;
    if (templateType == null) {
      throw new NullPointerException("Null templateType");
    }
    this.templateType = templateType;
  }

  @JsonProperty("id")
  @Nullable
  @Override
  public String id() {
    return id;
  }

  @JsonProperty("title")
  @Override
  public @NotBlank String title() {
    return title;
  }

  @JsonProperty("description")
  @Nullable
  @Override
  public String description() {
    return description;
  }

  @JsonProperty("default")
  @Override
  public boolean isDefault() {
    return isDefault;
  }

  @JsonProperty("writable")
  @Override
  public boolean isWritable() {
    return isWritable;
  }

  @JsonProperty("index_prefix")
  @Override
  public @Pattern(regexp = "^[a-z0-9][a-z0-9_+-]*$") String indexPrefix() {
    return indexPrefix;
  }

  @JsonProperty("shards")
  @Override
  public @Min(1L) int shards() {
    return shards;
  }

  @JsonProperty("replicas")
  @Override
  public @Min(0L) int replicas() {
    return replicas;
  }

  @JsonProperty("rotation_strategy_class")
  @Override
  public @NotNull String rotationStrategyClass() {
    return rotationStrategyClass;
  }

  @JsonProperty("rotation_strategy")
  @Override
  public @NotNull RotationStrategyConfig rotationStrategy() {
    return rotationStrategy;
  }

  @JsonProperty("retention_strategy_class")
  @Override
  public @NotNull String retentionStrategyClass() {
    return retentionStrategyClass;
  }

  @JsonProperty("retention_strategy")
  @Override
  public @NotNull RetentionStrategyConfig retentionStrategy() {
    return retentionStrategy;
  }

  @JsonProperty("creation_date")
  @Override
  public @NotNull ZonedDateTime creationDate() {
    return creationDate;
  }

  @JsonProperty("index_analyzer")
  @Override
  public @NotBlank String indexAnalyzer() {
    return indexAnalyzer;
  }

  @JsonProperty("index_optimization_max_num_segments")
  @Override
  public @Min(1L) int indexOptimizationMaxNumSegments() {
    return indexOptimizationMaxNumSegments;
  }

  @JsonProperty("index_optimization_disabled")
  @Override
  public boolean indexOptimizationDisabled() {
    return indexOptimizationDisabled;
  }

  @JsonProperty("field_type_refresh_interval")
  @Override
  public Duration fieldTypeRefreshInterval() {
    return fieldTypeRefreshInterval;
  }

  @JsonProperty("index_template_type")
  @Override
  public Optional<IndexSetConfig.TemplateType> templateType() {
    return templateType;
  }

  @Override
  public String toString() {
    return "IndexSetSummary{"
        + "id=" + id + ", "
        + "title=" + title + ", "
        + "description=" + description + ", "
        + "isDefault=" + isDefault + ", "
        + "isWritable=" + isWritable + ", "
        + "indexPrefix=" + indexPrefix + ", "
        + "shards=" + shards + ", "
        + "replicas=" + replicas + ", "
        + "rotationStrategyClass=" + rotationStrategyClass + ", "
        + "rotationStrategy=" + rotationStrategy + ", "
        + "retentionStrategyClass=" + retentionStrategyClass + ", "
        + "retentionStrategy=" + retentionStrategy + ", "
        + "creationDate=" + creationDate + ", "
        + "indexAnalyzer=" + indexAnalyzer + ", "
        + "indexOptimizationMaxNumSegments=" + indexOptimizationMaxNumSegments + ", "
        + "indexOptimizationDisabled=" + indexOptimizationDisabled + ", "
        + "fieldTypeRefreshInterval=" + fieldTypeRefreshInterval + ", "
        + "templateType=" + templateType
        + "}";
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof IndexSetSummary) {
      IndexSetSummary that = (IndexSetSummary) o;
      return (this.id == null ? that.id() == null : this.id.equals(that.id()))
          && this.title.equals(that.title())
          && (this.description == null ? that.description() == null : this.description.equals(that.description()))
          && this.isDefault == that.isDefault()
          && this.isWritable == that.isWritable()
          && this.indexPrefix.equals(that.indexPrefix())
          && this.shards == that.shards()
          && this.replicas == that.replicas()
          && this.rotationStrategyClass.equals(that.rotationStrategyClass())
          && this.rotationStrategy.equals(that.rotationStrategy())
          && this.retentionStrategyClass.equals(that.retentionStrategyClass())
          && this.retentionStrategy.equals(that.retentionStrategy())
          && this.creationDate.equals(that.creationDate())
          && this.indexAnalyzer.equals(that.indexAnalyzer())
          && this.indexOptimizationMaxNumSegments == that.indexOptimizationMaxNumSegments()
          && this.indexOptimizationDisabled == that.indexOptimizationDisabled()
          && this.fieldTypeRefreshInterval.equals(that.fieldTypeRefreshInterval())
          && this.templateType.equals(that.templateType());
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h$ = 1;
    h$ *= 1000003;
    h$ ^= (id == null) ? 0 : id.hashCode();
    h$ *= 1000003;
    h$ ^= title.hashCode();
    h$ *= 1000003;
    h$ ^= (description == null) ? 0 : description.hashCode();
    h$ *= 1000003;
    h$ ^= isDefault ? 1231 : 1237;
    h$ *= 1000003;
    h$ ^= isWritable ? 1231 : 1237;
    h$ *= 1000003;
    h$ ^= indexPrefix.hashCode();
    h$ *= 1000003;
    h$ ^= shards;
    h$ *= 1000003;
    h$ ^= replicas;
    h$ *= 1000003;
    h$ ^= rotationStrategyClass.hashCode();
    h$ *= 1000003;
    h$ ^= rotationStrategy.hashCode();
    h$ *= 1000003;
    h$ ^= retentionStrategyClass.hashCode();
    h$ *= 1000003;
    h$ ^= retentionStrategy.hashCode();
    h$ *= 1000003;
    h$ ^= creationDate.hashCode();
    h$ *= 1000003;
    h$ ^= indexAnalyzer.hashCode();
    h$ *= 1000003;
    h$ ^= indexOptimizationMaxNumSegments;
    h$ *= 1000003;
    h$ ^= indexOptimizationDisabled ? 1231 : 1237;
    h$ *= 1000003;
    h$ ^= fieldTypeRefreshInterval.hashCode();
    h$ *= 1000003;
    h$ ^= templateType.hashCode();
    return h$;
  }

}
