package org.graylog2.rest.resources.system.responses;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.nio.file.Path;
import javax.annotation.Generated;
import org.joda.time.Duration;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
abstract class $AutoValue_KafkaJournalConfigurationSummary extends KafkaJournalConfigurationSummary {

  private final Path directory;

  private final long segmentSize;

  private final Duration segmentAge;

  private final long maxSize;

  private final Duration maxAge;

  private final long flushInterval;

  private final Duration flushAge;

  $AutoValue_KafkaJournalConfigurationSummary(
      Path directory,
      long segmentSize,
      Duration segmentAge,
      long maxSize,
      Duration maxAge,
      long flushInterval,
      Duration flushAge) {
    if (directory == null) {
      throw new NullPointerException("Null directory");
    }
    this.directory = directory;
    this.segmentSize = segmentSize;
    if (segmentAge == null) {
      throw new NullPointerException("Null segmentAge");
    }
    this.segmentAge = segmentAge;
    this.maxSize = maxSize;
    if (maxAge == null) {
      throw new NullPointerException("Null maxAge");
    }
    this.maxAge = maxAge;
    this.flushInterval = flushInterval;
    if (flushAge == null) {
      throw new NullPointerException("Null flushAge");
    }
    this.flushAge = flushAge;
  }

  @JsonProperty("directory")
  @Override
  public Path directory() {
    return directory;
  }

  @JsonProperty("segment_size")
  @Override
  public long segmentSize() {
    return segmentSize;
  }

  @JsonProperty("segment_age")
  @JsonFormat(shape = JsonFormat.Shape.NUMBER)
  @Override
  public Duration segmentAge() {
    return segmentAge;
  }

  @JsonProperty("max_size")
  @Override
  public long maxSize() {
    return maxSize;
  }

  @JsonProperty("max_age")
  @JsonFormat(shape = JsonFormat.Shape.NUMBER)
  @Override
  public Duration maxAge() {
    return maxAge;
  }

  @JsonProperty("flush_interval")
  @Override
  public long flushInterval() {
    return flushInterval;
  }

  @JsonProperty("flush_age")
  @JsonFormat(shape = JsonFormat.Shape.NUMBER)
  @Override
  public Duration flushAge() {
    return flushAge;
  }

  @Override
  public String toString() {
    return "KafkaJournalConfigurationSummary{"
        + "directory=" + directory + ", "
        + "segmentSize=" + segmentSize + ", "
        + "segmentAge=" + segmentAge + ", "
        + "maxSize=" + maxSize + ", "
        + "maxAge=" + maxAge + ", "
        + "flushInterval=" + flushInterval + ", "
        + "flushAge=" + flushAge
        + "}";
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof KafkaJournalConfigurationSummary) {
      KafkaJournalConfigurationSummary that = (KafkaJournalConfigurationSummary) o;
      return this.directory.equals(that.directory())
          && this.segmentSize == that.segmentSize()
          && this.segmentAge.equals(that.segmentAge())
          && this.maxSize == that.maxSize()
          && this.maxAge.equals(that.maxAge())
          && this.flushInterval == that.flushInterval()
          && this.flushAge.equals(that.flushAge());
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h$ = 1;
    h$ *= 1000003;
    h$ ^= directory.hashCode();
    h$ *= 1000003;
    h$ ^= (int) ((segmentSize >>> 32) ^ segmentSize);
    h$ *= 1000003;
    h$ ^= segmentAge.hashCode();
    h$ *= 1000003;
    h$ ^= (int) ((maxSize >>> 32) ^ maxSize);
    h$ *= 1000003;
    h$ ^= maxAge.hashCode();
    h$ *= 1000003;
    h$ ^= (int) ((flushInterval >>> 32) ^ flushInterval);
    h$ *= 1000003;
    h$ ^= flushAge.hashCode();
    return h$;
  }

}
