package org.graylog2.streams;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.lang.Boolean;
import java.lang.String;
import java.util.Collection;
import javax.annotation.Nullable;
import org.bson.types.ObjectId;
import org.graylog2.plugin.streams.StreamRule;
import org.graylog2.rest.models.alarmcallbacks.requests.AlertReceivers;
import org.graylog2.rest.models.streams.alerts.AlertConditionSummary;

final class AutoValue_StreamDTO extends $AutoValue_StreamDTO {
  AutoValue_StreamDTO(String id, String creatorUserId, Collection<ObjectId> outputs,
      String matchingType, String description, String createdAt, Collection<StreamRule> rules,
      boolean disabled, Collection<AlertConditionSummary> alertConditions,
      AlertReceivers alertReceivers, String title, String contentPack, Boolean isDefault,
      Boolean removeMatchesFromDefaultStream, String indexSetId) {
    super(id, creatorUserId, outputs, matchingType, description, createdAt, rules, disabled, alertConditions, alertReceivers, title, contentPack, isDefault, removeMatchesFromDefaultStream, indexSetId);
  }

  @JsonIgnore
  public final String getId() {
    return id();
  }

  @JsonIgnore
  public final String getCreatorUserId() {
    return creatorUserId();
  }

  @JsonIgnore
  @Nullable
  public final Collection<ObjectId> getOutputs() {
    return outputs();
  }

  @JsonIgnore
  public final String getMatchingType() {
    return matchingType();
  }

  @JsonIgnore
  @Nullable
  public final String getDescription() {
    return description();
  }

  @JsonIgnore
  public final String getCreatedAt() {
    return createdAt();
  }

  @JsonIgnore
  @Nullable
  public final Collection<StreamRule> getRules() {
    return rules();
  }

  @JsonIgnore
  public final boolean isDisabled() {
    return disabled();
  }

  @JsonIgnore
  @Nullable
  public final Collection<AlertConditionSummary> getAlertConditions() {
    return alertConditions();
  }

  @JsonIgnore
  @Nullable
  public final AlertReceivers getAlertReceivers() {
    return alertReceivers();
  }

  @JsonIgnore
  public final String getTitle() {
    return title();
  }

  @JsonIgnore
  @Nullable
  public final String getContentPack() {
    return contentPack();
  }

  @JsonIgnore
  @Nullable
  public final Boolean isIsDefault() {
    return isDefault();
  }

  @JsonIgnore
  @Nullable
  public final Boolean isRemoveMatchesFromDefaultStream() {
    return removeMatchesFromDefaultStream();
  }

  @JsonIgnore
  public final String getIndexSetId() {
    return indexSetId();
  }
}
