package org.graylog2.system.processing;

import com.fasterxml.jackson.annotation.JsonProperty;
import javax.annotation.Generated;
import javax.annotation.Nullable;
import org.graylog2.plugin.lifecycles.Lifecycle;
import org.joda.time.DateTime;
import org.mongojack.Id;
import org.mongojack.ObjectId;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
final class AutoValue_ProcessingStatusDto extends ProcessingStatusDto {

  private final String id;

  private final String nodeId;

  private final Lifecycle nodeLifecycleStatus;

  private final DateTime updatedAt;

  private final ProcessingStatusDto.ReceiveTimes receiveTimes;

  private final ProcessingStatusDto.JournalInfo inputJournal;

  private AutoValue_ProcessingStatusDto(
      @Nullable String id,
      String nodeId,
      Lifecycle nodeLifecycleStatus,
      DateTime updatedAt,
      ProcessingStatusDto.ReceiveTimes receiveTimes,
      ProcessingStatusDto.JournalInfo inputJournal) {
    this.id = id;
    this.nodeId = nodeId;
    this.nodeLifecycleStatus = nodeLifecycleStatus;
    this.updatedAt = updatedAt;
    this.receiveTimes = receiveTimes;
    this.inputJournal = inputJournal;
  }

  @Id
  @ObjectId
  @Nullable
  @JsonProperty("id")
  @Override
  public String id() {
    return id;
  }

  @JsonProperty("node_id")
  @Override
  public String nodeId() {
    return nodeId;
  }

  @JsonProperty("node_lifecycle_status")
  @Override
  public Lifecycle nodeLifecycleStatus() {
    return nodeLifecycleStatus;
  }

  @JsonProperty("updated_at")
  @Override
  public DateTime updatedAt() {
    return updatedAt;
  }

  @JsonProperty("receive_times")
  @Override
  public ProcessingStatusDto.ReceiveTimes receiveTimes() {
    return receiveTimes;
  }

  @JsonProperty("input_journal")
  @Override
  public ProcessingStatusDto.JournalInfo inputJournal() {
    return inputJournal;
  }

  @Override
  public String toString() {
    return "ProcessingStatusDto{"
        + "id=" + id + ", "
        + "nodeId=" + nodeId + ", "
        + "nodeLifecycleStatus=" + nodeLifecycleStatus + ", "
        + "updatedAt=" + updatedAt + ", "
        + "receiveTimes=" + receiveTimes + ", "
        + "inputJournal=" + inputJournal
        + "}";
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof ProcessingStatusDto) {
      ProcessingStatusDto that = (ProcessingStatusDto) o;
      return (this.id == null ? that.id() == null : this.id.equals(that.id()))
          && this.nodeId.equals(that.nodeId())
          && this.nodeLifecycleStatus.equals(that.nodeLifecycleStatus())
          && this.updatedAt.equals(that.updatedAt())
          && this.receiveTimes.equals(that.receiveTimes())
          && this.inputJournal.equals(that.inputJournal());
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h$ = 1;
    h$ *= 1000003;
    h$ ^= (id == null) ? 0 : id.hashCode();
    h$ *= 1000003;
    h$ ^= nodeId.hashCode();
    h$ *= 1000003;
    h$ ^= nodeLifecycleStatus.hashCode();
    h$ *= 1000003;
    h$ ^= updatedAt.hashCode();
    h$ *= 1000003;
    h$ ^= receiveTimes.hashCode();
    h$ *= 1000003;
    h$ ^= inputJournal.hashCode();
    return h$;
  }

  @Override
  public ProcessingStatusDto.Builder toBuilder() {
    return new Builder(this);
  }

  static final class Builder extends ProcessingStatusDto.Builder {
    private String id;
    private String nodeId;
    private Lifecycle nodeLifecycleStatus;
    private DateTime updatedAt;
    private ProcessingStatusDto.ReceiveTimes receiveTimes;
    private ProcessingStatusDto.JournalInfo inputJournal;
    Builder() {
    }
    private Builder(ProcessingStatusDto source) {
      this.id = source.id();
      this.nodeId = source.nodeId();
      this.nodeLifecycleStatus = source.nodeLifecycleStatus();
      this.updatedAt = source.updatedAt();
      this.receiveTimes = source.receiveTimes();
      this.inputJournal = source.inputJournal();
    }
    @Override
    public ProcessingStatusDto.Builder id(String id) {
      this.id = id;
      return this;
    }
    @Override
    public ProcessingStatusDto.Builder nodeId(String nodeId) {
      if (nodeId == null) {
        throw new NullPointerException("Null nodeId");
      }
      this.nodeId = nodeId;
      return this;
    }
    @Override
    public ProcessingStatusDto.Builder nodeLifecycleStatus(Lifecycle nodeLifecycleStatus) {
      if (nodeLifecycleStatus == null) {
        throw new NullPointerException("Null nodeLifecycleStatus");
      }
      this.nodeLifecycleStatus = nodeLifecycleStatus;
      return this;
    }
    @Override
    public ProcessingStatusDto.Builder updatedAt(DateTime updatedAt) {
      if (updatedAt == null) {
        throw new NullPointerException("Null updatedAt");
      }
      this.updatedAt = updatedAt;
      return this;
    }
    @Override
    public ProcessingStatusDto.Builder receiveTimes(ProcessingStatusDto.ReceiveTimes receiveTimes) {
      if (receiveTimes == null) {
        throw new NullPointerException("Null receiveTimes");
      }
      this.receiveTimes = receiveTimes;
      return this;
    }
    @Override
    public ProcessingStatusDto.Builder inputJournal(ProcessingStatusDto.JournalInfo inputJournal) {
      if (inputJournal == null) {
        throw new NullPointerException("Null inputJournal");
      }
      this.inputJournal = inputJournal;
      return this;
    }
    @Override
    public ProcessingStatusDto build() {
      String missing = "";
      if (this.nodeId == null) {
        missing += " nodeId";
      }
      if (this.nodeLifecycleStatus == null) {
        missing += " nodeLifecycleStatus";
      }
      if (this.updatedAt == null) {
        missing += " updatedAt";
      }
      if (this.receiveTimes == null) {
        missing += " receiveTimes";
      }
      if (this.inputJournal == null) {
        missing += " inputJournal";
      }
      if (!missing.isEmpty()) {
        throw new IllegalStateException("Missing required properties:" + missing);
      }
      return new AutoValue_ProcessingStatusDto(
          this.id,
          this.nodeId,
          this.nodeLifecycleStatus,
          this.updatedAt,
          this.receiveTimes,
          this.inputJournal);
    }
  }

}
