/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.contentpacks.facades.dashboardV1;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.graylog.plugins.views.search.Parameter;
import org.graylog.plugins.views.search.elasticsearch.ElasticsearchQueryString;
import org.graylog.plugins.views.search.views.PluginMetadataSummary;
import org.graylog.plugins.views.search.views.Titles;
import org.graylog.plugins.views.search.views.WidgetPositionDTO;
import org.graylog2.contentpacks.facades.dashboardV1.DashboardWidgetConverter;
import org.graylog2.contentpacks.model.entities.DashboardEntity;
import org.graylog2.contentpacks.model.entities.DashboardWidgetEntity;
import org.graylog2.contentpacks.model.entities.QueryEntity;
import org.graylog2.contentpacks.model.entities.SearchEntity;
import org.graylog2.contentpacks.model.entities.SearchTypeEntity;
import org.graylog2.contentpacks.model.entities.ViewEntity;
import org.graylog2.contentpacks.model.entities.ViewStateEntity;
import org.graylog2.contentpacks.model.entities.WidgetEntity;
import org.graylog2.contentpacks.model.entities.references.ValueReference;
import org.graylog2.plugin.indexer.searches.timeranges.InvalidRangeParametersException;
import org.graylog2.plugin.indexer.searches.timeranges.RelativeRange;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;

public class EntityConverter {
    private DashboardEntity dashboardEntity;
    private Map<String, ValueReference> parameters;
    private DashboardWidgetConverter dashboardWidgetConverter;

    @Inject
    public EntityConverter(DashboardWidgetConverter dashboardWidgetConverter) {
        this.dashboardWidgetConverter = dashboardWidgetConverter;
    }

    public ViewEntity convert(DashboardEntity dashboardEntity, Map<String, ValueReference> parameters) {
        SearchEntity searchEntity;
        this.parameters = parameters;
        this.dashboardEntity = dashboardEntity;
        String queryId = UUID.randomUUID().toString();
        Map<DashboardWidgetEntity, List<WidgetEntity>> widgets = this.convertWidgets();
        Map<String, WidgetPositionDTO> widgetPositionMap = DashboardEntity.positionMap(parameters, widgets);
        Titles titles = DashboardEntity.widgetTitles(widgets, parameters);
        HashMap<String, Set<String>> widgetMapping = new HashMap<String, Set<String>>();
        HashSet<SearchTypeEntity> searchTypes = new HashSet<SearchTypeEntity>();
        this.createSearchTypes(widgets, widgetMapping, searchTypes);
        try {
            searchEntity = this.createSearchEntity(queryId, searchTypes);
        }
        catch (InvalidRangeParametersException e) {
            throw new IllegalArgumentException("The provided entity does not have a valid TimeRange", e);
        }
        ViewStateEntity viewStateEntity = ViewStateEntity.builder().widgets(widgets.values().stream().flatMap(Collection::stream).collect(Collectors.toSet())).titles(titles).widgetMapping(widgetMapping).widgetPositions(widgetPositionMap).build();
        ImmutableMap viewStateEntityMap = ImmutableMap.of((Object)queryId, (Object)viewStateEntity);
        return ViewEntity.builder().search(searchEntity).state((Map<String, ViewStateEntity>)viewStateEntityMap).title(dashboardEntity.title()).properties(Collections.emptySet()).description(dashboardEntity.description()).requires(Collections.emptyMap()).summary(ValueReference.of("Converted Dashboard")).createdAt(DateTime.now((DateTimeZone)DateTimeZone.UTC)).type(ViewEntity.Type.DASHBOARD).build();
    }

    private Map<DashboardWidgetEntity, List<WidgetEntity>> convertWidgets() {
        HashMap<DashboardWidgetEntity, List<WidgetEntity>> widgets = new HashMap<DashboardWidgetEntity, List<WidgetEntity>>();
        for (DashboardWidgetEntity widgetEntity : this.dashboardEntity.widgets()) {
            widgets.put(widgetEntity, this.dashboardWidgetConverter.convert(widgetEntity, this.parameters));
        }
        return widgets;
    }

    private void createSearchTypes(Map<DashboardWidgetEntity, List<WidgetEntity>> widgets, Map<String, Set<String>> widgetMapping, Set<SearchTypeEntity> searchTypes) {
        for (Map.Entry<DashboardWidgetEntity, List<WidgetEntity>> widgetEntityListEntry : widgets.entrySet()) {
            widgetEntityListEntry.getValue().forEach(widgetEntity -> {
                List<SearchTypeEntity> currentSearchTypes = widgetEntity.createSearchTypeEntity();
                searchTypes.addAll(currentSearchTypes);
                widgetMapping.put(widgetEntity.id(), currentSearchTypes.stream().map(SearchTypeEntity::id).collect(Collectors.toSet()));
            });
        }
    }

    private SearchEntity createSearchEntity(String queryId, Set<SearchTypeEntity> searchTypes) throws InvalidRangeParametersException {
        QueryEntity query = QueryEntity.builder().id(queryId).searchTypes(searchTypes).timerange(RelativeRange.create(300)).query(ElasticsearchQueryString.builder().queryString("").build()).build();
        return SearchEntity.builder().requires((Map<String, PluginMetadataSummary>)ImmutableMap.of()).parameters((ImmutableSet<Parameter>)ImmutableSet.of()).createdAt(DateTime.now((DateTimeZone)DateTimeZone.UTC)).queries((ImmutableSet<QueryEntity>)ImmutableSet.of((Object)query)).build();
    }
}

