/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.indexer;

import com.github.zafarkhaja.semver.Version;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.graylog2.indexer.ElasticsearchException;
import org.graylog2.indexer.EventsIndexMapping6;
import org.graylog2.indexer.EventsIndexMapping7;
import org.graylog2.indexer.GIMMapping6;
import org.graylog2.indexer.GIMMapping7;
import org.graylog2.indexer.IndexMapping;
import org.graylog2.indexer.IndexMapping5;
import org.graylog2.indexer.IndexMapping6;
import org.graylog2.indexer.IndexMapping7;
import org.graylog2.indexer.IndexMappingTemplate;
import org.graylog2.indexer.cluster.Node;
import org.graylog2.indexer.indexset.IndexSetConfig;

@Singleton
public class IndexMappingFactory {
    private final Node node;

    @Inject
    public IndexMappingFactory(Node node) {
        this.node = node;
    }

    public IndexMappingTemplate createIndexMapping(IndexSetConfig.TemplateType templateType) {
        Version elasticsearchVersion = this.node.getVersion().orElseThrow(() -> new ElasticsearchException("Unable to retrieve Elasticsearch version."));
        switch (templateType) {
            case MESSAGES: {
                return IndexMappingFactory.indexMappingFor(elasticsearchVersion);
            }
            case EVENTS: {
                return IndexMappingFactory.eventsIndexMappingFor(elasticsearchVersion);
            }
            case GIM_V1: {
                return this.gimMappingFor(elasticsearchVersion);
            }
        }
        throw new IllegalStateException("Invalid index template type: " + (Object)((Object)templateType));
    }

    private IndexMapping gimMappingFor(Version elasticsearchVersion) {
        if (elasticsearchVersion.satisfies("^6.0.0")) {
            return new GIMMapping6();
        }
        if (elasticsearchVersion.satisfies("^7.0.0")) {
            return new GIMMapping7();
        }
        throw new ElasticsearchException("Unsupported Elasticsearch version: " + elasticsearchVersion);
    }

    public static IndexMapping indexMappingFor(Version elasticsearchVersion) {
        if (elasticsearchVersion.satisfies("^5.0.0")) {
            return new IndexMapping5();
        }
        if (elasticsearchVersion.satisfies("^6.0.0")) {
            return new IndexMapping6();
        }
        if (elasticsearchVersion.satisfies("^7.0.0")) {
            return new IndexMapping7();
        }
        throw new ElasticsearchException("Unsupported Elasticsearch version: " + elasticsearchVersion);
    }

    public static IndexMappingTemplate eventsIndexMappingFor(Version elasticsearchVersion) {
        if (elasticsearchVersion.satisfies("^5.0.0 | ^6.0.0")) {
            return new EventsIndexMapping6();
        }
        if (elasticsearchVersion.satisfies("^7.0.0")) {
            return new EventsIndexMapping7();
        }
        throw new ElasticsearchException("Unsupported Elasticsearch version: " + elasticsearchVersion);
    }
}

