/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.indexer;

import com.google.auto.value.AutoValue;
import java.util.Optional;
import javax.inject.Inject;
import org.graylog2.indexer.AutoValue_IndexSetValidator_Violation;
import org.graylog2.indexer.IndexSet;
import org.graylog2.indexer.IndexSetRegistry;
import org.graylog2.indexer.indexset.IndexSetConfig;
import org.joda.time.Duration;
import org.joda.time.ReadableDuration;

public class IndexSetValidator {
    private static final Duration MINIMUM_FIELD_TYPE_REFRESH_INTERVAL = Duration.standardSeconds((long)1L);
    private final IndexSetRegistry indexSetRegistry;

    @Inject
    public IndexSetValidator(IndexSetRegistry indexSetRegistry) {
        this.indexSetRegistry = indexSetRegistry;
    }

    public Optional<Violation> validate(IndexSetConfig newConfig) {
        String indexName = newConfig.indexPrefix() + "_" + "0";
        if (this.indexSetRegistry.isManagedIndex(indexName)) {
            return Optional.of(Violation.create("Index prefix \"" + newConfig.indexPrefix() + "\" would conflict with an existing index set!"));
        }
        for (IndexSet indexSet : this.indexSetRegistry) {
            if (!newConfig.indexPrefix().startsWith(indexSet.getIndexPrefix()) && !indexSet.getIndexPrefix().startsWith(newConfig.indexPrefix())) continue;
            return Optional.of(Violation.create("Index prefix \"" + newConfig.indexPrefix() + "\" would conflict with existing index set prefix \"" + indexSet.getIndexPrefix() + "\""));
        }
        if (newConfig.fieldTypeRefreshInterval().isShorterThan((ReadableDuration)MINIMUM_FIELD_TYPE_REFRESH_INTERVAL)) {
            return Optional.of(Violation.create("Index field_type_refresh_interval \"" + newConfig.fieldTypeRefreshInterval().toString() + "\" is too short. It must be 1 second or longer."));
        }
        return Optional.empty();
    }

    @AutoValue
    public static abstract class Violation {
        public abstract String message();

        public static Violation create(String message) {
            return new AutoValue_IndexSetValidator_Violation(message);
        }
    }
}

