/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.views.search.views;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.mongodb.DuplicateKeyException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.inject.Inject;
import org.bson.types.ObjectId;
import org.graylog.plugins.views.search.views.PluginMetadataSummary;
import org.graylog.plugins.views.search.views.ViewClusterConfig;
import org.graylog.plugins.views.search.views.ViewDTO;
import org.graylog.plugins.views.search.views.ViewRequirements;
import org.graylog.plugins.views.search.views.ViewSummaryDTO;
import org.graylog.plugins.views.search.views.ViewSummaryService;
import org.graylog.security.entities.EntityOwnershipService;
import org.graylog2.bindings.providers.MongoJackObjectMapperProvider;
import org.graylog2.database.MongoConnection;
import org.graylog2.database.PaginatedDbService;
import org.graylog2.database.PaginatedList;
import org.graylog2.plugin.cluster.ClusterConfigService;
import org.graylog2.plugin.database.users.User;
import org.graylog2.search.SearchQuery;
import org.mongojack.DBQuery;
import org.mongojack.WriteResult;

public class ViewService
extends PaginatedDbService<ViewDTO> {
    private static final String COLLECTION_NAME = "views";
    private final ClusterConfigService clusterConfigService;
    private final ViewRequirements.Factory viewRequirementsFactory;
    private final EntityOwnershipService entityOwnerShipService;
    private final ViewSummaryService viewSummaryService;

    @Inject
    protected ViewService(MongoConnection mongoConnection, MongoJackObjectMapperProvider mapper, ClusterConfigService clusterConfigService, ViewRequirements.Factory viewRequirementsFactory, EntityOwnershipService entityOwnerShipService, ViewSummaryService viewSummaryService) {
        super(mongoConnection, mapper, ViewDTO.class, COLLECTION_NAME);
        this.clusterConfigService = clusterConfigService;
        this.viewRequirementsFactory = viewRequirementsFactory;
        this.entityOwnerShipService = entityOwnerShipService;
        this.viewSummaryService = viewSummaryService;
    }

    private PaginatedList<ViewDTO> searchPaginated(DBQuery.Query query, Predicate<ViewDTO> filter, DBQuery.Query grandTotalQuery, String order, String sortField, int page, int perPage) {
        PaginatedList<ViewDTO> viewsList = this.findPaginatedWithQueryFilterAndSortWithGrandTotalQuery(query, filter, this.getSortBuilder(order, sortField), grandTotalQuery, page, perPage);
        return viewsList.stream().map(this::requirementsForView).collect(Collectors.toCollection(() -> viewsList.grandTotal().map(grandTotal -> new PaginatedList(new ArrayList(viewsList.size()), viewsList.pagination().total(), page, perPage, (Long)grandTotal)).orElseGet(() -> new PaginatedList(new ArrayList(viewsList.size()), viewsList.pagination().total(), page, perPage))));
    }

    public PaginatedList<ViewDTO> searchPaginated(SearchQuery query, Predicate<ViewDTO> filter, String order, String sortField, int page, int perPage) {
        return this.searchPaginated(query.toDBQuery(), filter, DBQuery.empty(), order, sortField, page, perPage);
    }

    public PaginatedList<ViewDTO> searchPaginatedByType(ViewDTO.Type type, SearchQuery query, Predicate<ViewDTO> filter, String order, String sortField, int page, int perPage) {
        Preconditions.checkNotNull((Object)sortField);
        return this.searchPaginated(DBQuery.and((DBQuery.Query[])new DBQuery.Query[]{DBQuery.or((DBQuery.Query[])new DBQuery.Query[]{DBQuery.is((String)"type", (Object)((Object)type)), DBQuery.notExists((String)"type")}), query.toDBQuery()}), filter, DBQuery.or((DBQuery.Query[])new DBQuery.Query[]{DBQuery.is((String)"type", (Object)((Object)type)), DBQuery.notExists((String)"type")}), order, sortField, page, perPage);
    }

    public PaginatedList<ViewSummaryDTO> searchSummariesPaginatedByType(ViewDTO.Type type, SearchQuery query, Predicate<ViewSummaryDTO> filter, String order, String sortField, int page, int perPage) {
        return this.viewSummaryService.searchPaginatedByType(type, query, filter, order, sortField, page, perPage);
    }

    public void saveDefault(ViewDTO dto) {
        if (Strings.isNullOrEmpty((String)dto.id())) {
            throw new IllegalArgumentException("ViewDTO needs an ID to be configured as default view");
        }
        this.clusterConfigService.write(ViewClusterConfig.builder().defaultViewId(dto.id()).build());
    }

    public Optional<ViewDTO> getDefault() {
        return Optional.ofNullable(this.clusterConfigService.get(ViewClusterConfig.class)).flatMap(config -> this.get(config.defaultViewId()));
    }

    public Collection<ViewDTO> forSearch(String searchId) {
        return this.db.find(DBQuery.is((String)"search_id", (Object)searchId)).toArray().stream().map(this::requirementsForView).collect(Collectors.toSet());
    }

    @Override
    public Optional<ViewDTO> get(String id) {
        return super.get(id).map(this::requirementsForView);
    }

    @Override
    public Stream<ViewDTO> streamAll() {
        return super.streamAll().map(this::requirementsForView);
    }

    @Override
    public Stream<ViewDTO> streamByIds(Set<String> idSet) {
        return super.streamByIds(idSet).map(this::requirementsForView);
    }

    public ViewDTO saveWithOwner(ViewDTO viewDTO, User user) {
        ViewDTO savedObject = this.save(viewDTO);
        if (viewDTO.type().equals((Object)ViewDTO.Type.DASHBOARD)) {
            this.entityOwnerShipService.registerNewDashboard(savedObject.id(), user);
        } else {
            this.entityOwnerShipService.registerNewSearch(savedObject.id(), user);
        }
        return savedObject;
    }

    @Override
    public ViewDTO save(ViewDTO viewDTO) {
        try {
            WriteResult save = this.db.insert((Object)this.requirementsForView(viewDTO));
            return (ViewDTO)save.getSavedObject();
        }
        catch (DuplicateKeyException e) {
            throw new IllegalStateException("Unable to save view, it already exists.");
        }
    }

    @Override
    public int delete(String id) {
        this.get(id).ifPresent(view -> {
            if (view.type().equals((Object)ViewDTO.Type.DASHBOARD)) {
                this.entityOwnerShipService.unregisterDashboard(id);
            } else {
                this.entityOwnerShipService.unregisterSearch(id);
            }
        });
        return super.delete(id);
    }

    public ViewDTO update(ViewDTO viewDTO) {
        Preconditions.checkArgument((viewDTO.id() != null ? 1 : 0) != 0, (Object)"Id of view must not be null.");
        ViewDTO viewWithRequirements = this.requirementsForView(viewDTO);
        this.db.updateById((Object)new ObjectId(viewWithRequirements.id()), (Object)viewWithRequirements);
        return viewWithRequirements;
    }

    private ViewDTO requirementsForView(ViewDTO view) {
        return this.viewRequirementsFactory.create(view).rebuildRequirements(ViewDTO::requires, (v, newRequirements) -> v.toBuilder().requires((Map<String, PluginMetadataSummary>)newRequirements).build());
    }
}

