/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.contentpacks.model.entities;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.auto.value.AutoValue;
import com.google.common.collect.ImmutableList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.graylog.plugins.views.search.engine.BackendQuery;
import org.graylog.plugins.views.search.searchtypes.pivot.BucketSpec;
import org.graylog.plugins.views.search.searchtypes.pivot.PivotSort;
import org.graylog.plugins.views.search.searchtypes.pivot.SeriesSpec;
import org.graylog.plugins.views.search.searchtypes.pivot.SortSpec;
import org.graylog.plugins.views.search.searchtypes.pivot.buckets.AutoInterval;
import org.graylog.plugins.views.search.searchtypes.pivot.buckets.Time;
import org.graylog.plugins.views.search.searchtypes.pivot.buckets.Values;
import org.graylog.plugins.views.search.searchtypes.pivot.series.Average;
import org.graylog.plugins.views.search.searchtypes.pivot.series.Cardinality;
import org.graylog.plugins.views.search.searchtypes.pivot.series.Count;
import org.graylog.plugins.views.search.searchtypes.pivot.series.Max;
import org.graylog.plugins.views.search.searchtypes.pivot.series.Min;
import org.graylog.plugins.views.search.searchtypes.pivot.series.StdDev;
import org.graylog.plugins.views.search.searchtypes.pivot.series.Sum;
import org.graylog.plugins.views.search.searchtypes.pivot.series.Variance;
import org.graylog.plugins.views.search.timeranges.OffsetRange;
import org.graylog.plugins.views.search.views.WidgetConfigDTO;
import org.graylog.plugins.views.search.views.WidgetDTO;
import org.graylog.plugins.views.search.views.widgets.aggregation.AggregationConfigDTO;
import org.graylog.plugins.views.search.views.widgets.aggregation.sort.PivotSortConfig;
import org.graylog.plugins.views.search.views.widgets.aggregation.sort.SortConfigDTO;
import org.graylog2.contentpacks.NativeEntityConverter;
import org.graylog2.contentpacks.exceptions.ContentPackException;
import org.graylog2.contentpacks.model.ModelTypes;
import org.graylog2.contentpacks.model.entities.$AutoValue_WidgetEntity;
import org.graylog2.contentpacks.model.entities.EntityDescriptor;
import org.graylog2.contentpacks.model.entities.PivotEntity;
import org.graylog2.contentpacks.model.entities.SearchTypeEntity;
import org.graylog2.contentpacks.model.entities.references.ValueReference;
import org.graylog2.plugin.indexer.searches.timeranges.TimeRange;
import org.graylog2.plugin.streams.Stream;

@JsonDeserialize(builder=Builder.class)
@AutoValue
public abstract class WidgetEntity
implements NativeEntityConverter<WidgetDTO> {
    public static final String FIELD_ID = "id";
    public static final String FIELD_TYPE = "type";
    public static final String FIELD_FILTER = "filter";
    public static final String FIELD_CONFIG = "config";
    public static final String FIELD_TIMERANGE = "timerange";
    public static final String FIELD_QUERY = "query";
    public static final String FIELD_STREAMS = "streams";

    @JsonProperty(value="id")
    public abstract String id();

    @JsonProperty(value="type")
    public abstract String type();

    @JsonProperty(value="filter")
    @Nullable
    public abstract String filter();

    @JsonProperty(value="timerange")
    public abstract Optional<TimeRange> timerange();

    @JsonProperty(value="query")
    public abstract Optional<BackendQuery> query();

    @JsonProperty(value="streams")
    public abstract Set<String> streams();

    @JsonProperty(value="config")
    public abstract WidgetConfigDTO config();

    public static Builder builder() {
        return Builder.builder();
    }

    @Override
    public WidgetDTO toNativeEntity(Map<String, ValueReference> parameters, Map<EntityDescriptor, Object> nativeEntities) {
        WidgetDTO.Builder widgetBuilder = WidgetDTO.builder().config(this.config()).filter(this.filter()).id(this.id()).streams(this.streams().stream().map(id -> EntityDescriptor.create(id, ModelTypes.STREAM_V1)).map(nativeEntities::get).map(object -> {
            if (object == null) {
                throw new ContentPackException("Missing Stream for widget entity");
            }
            if (object instanceof Stream) {
                Stream stream = (Stream)object;
                return stream.getId();
            }
            throw new ContentPackException("Invalid type for stream Stream for event definition: " + object.getClass());
        }).collect(Collectors.toSet())).type(this.type());
        if (this.query().isPresent()) {
            widgetBuilder.query(this.query().get());
        }
        if (this.timerange().isPresent()) {
            widgetBuilder.timerange(this.timerange().get());
        }
        return widgetBuilder.build();
    }

    public List<SearchTypeEntity> createSearchTypeEntity() {
        if (!this.type().matches("aggregation")) {
            return ImmutableList.of();
        }
        AggregationConfigDTO config = (AggregationConfigDTO)this.config();
        PivotEntity.Builder pivotBuilder = ((PivotEntity.Builder)PivotEntity.builder().name("chart").streams((Set)this.streams())).rollup(true).sort(this.toSortSpec(config)).rowGroups(this.toRowGroups(config)).series(this.toSeriesSpecs(config)).id(UUID.randomUUID().toString());
        this.query().ifPresent(pivotBuilder::query);
        this.timerange().ifPresent(pivotBuilder::timerange);
        if (config.visualization().matches("numeric")) {
            PivotEntity chart = pivotBuilder.build();
            PivotEntity trend = pivotBuilder.id(UUID.randomUUID().toString()).name("trend").timerange(OffsetRange.Builder.builder().source("search_type").id(chart.id()).build()).build();
            return ImmutableList.of((Object)chart, (Object)trend);
        }
        return ImmutableList.of((Object)pivotBuilder.build());
    }

    private List<SortSpec> toSortSpec(AggregationConfigDTO config) {
        return config.sort().stream().map(sortConfig -> {
            PivotSortConfig pivotSortConfig = (PivotSortConfig)sortConfig;
            SortSpec.Direction dir = pivotSortConfig.direction().equals((Object)SortConfigDTO.Direction.Ascending) ? SortSpec.Direction.Ascending : SortSpec.Direction.Descending;
            return PivotSort.create("pivot", pivotSortConfig.field(), dir);
        }).collect(Collectors.toList());
    }

    private List<BucketSpec> toRowGroups(AggregationConfigDTO config) {
        return config.rowPivots().stream().map(rowPivot -> {
            if (rowPivot.type().matches("time")) {
                return (BucketSpec)Time.builder().field(rowPivot.field()).interval(AutoInterval.create()).build();
            }
            return (BucketSpec)Values.builder().field(rowPivot.field()).build();
        }).collect(Collectors.toList());
    }

    private List<SeriesSpec> toSeriesSpecs(AggregationConfigDTO config) {
        return config.series().stream().map(seriesDTO -> {
            String function = seriesDTO.function();
            Pattern pattern = Pattern.compile("\\((.*?)\\)");
            Matcher matcher = pattern.matcher(function);
            String field = "";
            if (matcher.find()) {
                field = matcher.group(1);
            }
            if (function.startsWith("card")) {
                return Cardinality.builder().field(field).id(function).build();
            }
            if (function.startsWith("avg")) {
                return Average.builder().field(field).id(function).build();
            }
            if (function.startsWith("max")) {
                return Max.builder().field(field).id(function).build();
            }
            if (function.startsWith("min")) {
                return Min.builder().field(field).id(function).build();
            }
            if (function.startsWith("sum")) {
                return Sum.builder().field(field).id(function).build();
            }
            if (function.startsWith("variance")) {
                return Variance.builder().field(field).id(function).build();
            }
            if (function.startsWith("stddev")) {
                return StdDev.builder().field(field).id(function).build();
            }
            if (function.startsWith("count")) {
                Count.Builder countBuilder = Count.builder().id(function);
                if (!field.isEmpty()) {
                    countBuilder.field(field);
                }
                return countBuilder.build();
            }
            throw new IllegalArgumentException("The provided entity does not have a valid function type: " + function);
        }).collect(Collectors.toList());
    }

    @AutoValue.Builder
    public static abstract class Builder {
        @JsonProperty(value="id")
        public abstract Builder id(String var1);

        @JsonProperty(value="type")
        public abstract Builder type(String var1);

        @JsonProperty(value="filter")
        public abstract Builder filter(@Nullable String var1);

        @JsonProperty(value="timerange")
        public abstract Builder timerange(@Nullable TimeRange var1);

        @JsonProperty(value="query")
        public abstract Builder query(@Nullable BackendQuery var1);

        @JsonProperty(value="streams")
        public abstract Builder streams(Set<String> var1);

        @JsonProperty(value="config")
        @JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.EXTERNAL_PROPERTY, property="type", visible=true)
        public abstract Builder config(WidgetConfigDTO var1);

        public abstract WidgetEntity build();

        @JsonCreator
        static Builder builder() {
            return new $AutoValue_WidgetEntity.Builder().streams(Collections.emptySet());
        }
    }
}

