/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.views.migrations.V20191125144500_MigrateDashboardsToViewsSupport.dashboardwidgets;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.auto.value.AutoValue;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.graylog.plugins.views.migrations.V20191125144500_MigrateDashboardsToViewsSupport.AggregationWidget;
import org.graylog.plugins.views.migrations.V20191125144500_MigrateDashboardsToViewsSupport.RandomUUIDProvider;
import org.graylog.plugins.views.migrations.V20191125144500_MigrateDashboardsToViewsSupport.TimeRange;
import org.graylog.plugins.views.migrations.V20191125144500_MigrateDashboardsToViewsSupport.ViewWidget;
import org.graylog.plugins.views.migrations.V20191125144500_MigrateDashboardsToViewsSupport.ViewWidgetPosition;
import org.graylog.plugins.views.migrations.V20191125144500_MigrateDashboardsToViewsSupport.Widget;
import org.graylog.plugins.views.migrations.V20191125144500_MigrateDashboardsToViewsSupport.WidgetPosition;
import org.graylog.plugins.views.migrations.V20191125144500_MigrateDashboardsToViewsSupport.dashboardwidgets.AutoValue_StackedChartConfig;
import org.graylog.plugins.views.migrations.V20191125144500_MigrateDashboardsToViewsSupport.dashboardwidgets.StackedSeries;
import org.graylog.plugins.views.migrations.V20191125144500_MigrateDashboardsToViewsSupport.dashboardwidgets.WidgetConfig;
import org.graylog.plugins.views.migrations.V20191125144500_MigrateDashboardsToViewsSupport.dashboardwidgets.WidgetConfigBase;
import org.graylog.plugins.views.migrations.V20191125144500_MigrateDashboardsToViewsSupport.viewwidgets.AggregationConfig;
import org.graylog.plugins.views.migrations.V20191125144500_MigrateDashboardsToViewsSupport.viewwidgets.Series;
import org.graylog.plugins.views.migrations.V20191125144500_MigrateDashboardsToViewsSupport.viewwidgets.VisualizationConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonAutoDetect
@JsonIgnoreProperties(ignoreUnknown=true)
@AutoValue
public abstract class StackedChartConfig
extends WidgetConfigBase
implements WidgetConfig {
    private static final Logger LOG = LoggerFactory.getLogger(StackedChartConfig.class);

    public abstract String interval();

    public abstract String renderer();

    public abstract String interpolation();

    public abstract List<StackedSeries> series();

    public abstract Optional<String> streamId();

    @Override
    public Set<ViewWidget> toViewWidgets(Widget widget, RandomUUIDProvider randomUUIDProvider) {
        Map<String, List<StackedSeries>> seriesByQuery = this.series().stream().collect(Collectors.groupingBy(StackedSeries::query));
        AggregationConfig.Builder configBuilderTemplate = AggregationConfig.builder().rowPivots(this.timestampPivot(this.interval())).visualization(this.mapRendererToVisualization(this.renderer()));
        if (seriesByQuery.size() > 1) {
            LOG.warn("Migrating dashboards to views: Encountered a stacked chart widget containing multiple distinct queries, splitting up into separate widgets. Read more about it here: https://github.com/Graylog2/graylog2-server/blob/master/UPGRADING.rst#upgrading-to-graylog-32x");
        }
        return seriesByQuery.entrySet().stream().map(entry -> {
            String query = (String)entry.getKey();
            List<Series> series = ((List)entry.getValue()).stream().map(s -> Series.create(this.mapStatsFunction(s.statisticalFunction()), s.field())).collect(Collectors.toList());
            AggregationConfig.Builder configBuilder = configBuilderTemplate.series(series);
            AggregationWidget.Builder viewWidgetBuilder = AggregationWidget.builder().id(randomUUIDProvider.get()).timerange(this.timerange()).query(query).config(this.visualizationConfig().map(configBuilder::visualizationConfig).orElse(configBuilder).build());
            return this.streamId().map(streamId -> viewWidgetBuilder.streams(Collections.singleton(streamId))).orElse(viewWidgetBuilder).build();
        }).collect(Collectors.toSet());
    }

    @Override
    public Map<String, ViewWidgetPosition> toViewWidgetPositions(Set<ViewWidget> viewWidgets, WidgetPosition widgetPosition) {
        if (viewWidgets.size() == 1) {
            return super.toViewWidgetPositions(viewWidgets, widgetPosition);
        }
        List widgetList = viewWidgets.stream().filter(viewWidget -> viewWidget instanceof AggregationWidget).map(viewWidget -> (AggregationWidget)viewWidget).collect(Collectors.toList());
        AggregationWidget first = (AggregationWidget)widgetList.get(0);
        ViewWidgetPosition firstPosition = ViewWidgetPosition.builder().col(widgetPosition.col()).row(widgetPosition.row()).height(widgetPosition.height()).width(widgetPosition.width()).build();
        return Collections.singletonMap(first.id(), firstPosition);
    }

    private Optional<VisualizationConfig> visualizationConfig() {
        return this.createVisualizationConfig(this.renderer(), this.interpolation());
    }

    @JsonCreator
    public static StackedChartConfig create(@JsonProperty(value="timerange") TimeRange timeRange, @JsonProperty(value="interval") String interval, @JsonProperty(value="renderer") String renderer, @JsonProperty(value="interpolation") String interpolation, @JsonProperty(value="series") List<StackedSeries> series, @JsonProperty(value="stream_id") @Nullable String streamId) {
        return new AutoValue_StackedChartConfig(timeRange, interval, renderer, interpolation, series, Optional.ofNullable(streamId));
    }
}

