/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.indexer;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.graylog2.indexer.IndexMapping;

public abstract class GIMMapping
extends IndexMapping {
    private static final Set<String> KEYWORD_FIELDS = ImmutableSet.builder().add((Object)"gl2_gims_version").add((Object)"gl2_tags").add((Object)"gl2_event_category").add((Object)"gl2_event_subcategory").add((Object)"gl2_event_type").add((Object)"user_command").add((Object)"user_command_path").add((Object)"user_domain").add((Object)"user_email").add((Object)"user_id").add((Object)"user_category").add((Object)"user_type").add((Object)"user_priority").add((Object)"source_user_domain").add((Object)"source_user_email").add((Object)"source_user_id").add((Object)"source_user_category").add((Object)"source_user_type").add((Object)"source_user_priority").add((Object)"target_user_domain").add((Object)"target_user_email").add((Object)"target_user_id").add((Object)"target_user_category").add((Object)"target_user_type").add((Object)"target_user_priority").add((Object)"http_application").add((Object)"http_content_type").add((Object)"http_host").add((Object)"http_path").add((Object)"http_referrer").add((Object)"http_method").add((Object)"http_response").add((Object)"http_user_agent").add((Object)"http_user_agent_name").add((Object)"http_url").add((Object)"http_url_category").add((Object)"http_user_agent_os").add((Object)"http_version").add((Object)"http_xff").add((Object)"host_as_domain").add((Object)"host_as_isp").add((Object)"host_as_organization").add((Object)"host_as_number").add((Object)"host_geo_city").add((Object)"host_geo_country").add((Object)"host_geo_name").add((Object)"host_geo_country_iso").add((Object)"host_geo_coordinates").add((Object)"host_location_name").add((Object)"host_mac").add((Object)"host_category").add((Object)"host_priority").add((Object)"host_id").add((Object)"host_type").add((Object)"host_type_version").add((Object)"host_virtfw_id").add((Object)"host_virtfw_uid").add((Object)"source_as_organization").add((Object)"source_as_domain").add((Object)"source_as_number").add((Object)"source_geo_city").add((Object)"source_geo_country").add((Object)"source_geo_name").add((Object)"source_geo_country_iso").add((Object)"source_geo_coordinates").add((Object)"source_category").add((Object)"source_location_name").add((Object)"source_mac").add((Object)"source_priority").add((Object)"source_id").add((Object)"source_type").add((Object)"source_vsys_uuid").add((Object)"source_zone").add((Object)"destination_application_name").add((Object)"destination_as_domain").add((Object)"destination_as_isp").add((Object)"destination_as_organization").add((Object)"destination_as_number").add((Object)"destination_geo_city_name").add((Object)"destination_geo_country_name").add((Object)"destination_geo_name").add((Object)"destination_geo_state_name").add((Object)"destination_geo_country_iso").add((Object)"destination_geo_coordinates").add((Object)"destination_category").add((Object)"destination_location_name").add((Object)"destination_mac").add((Object)"destination_priority").add((Object)"destination_id").add((Object)"destination_type").add((Object)"destination_vsys_uuid").add((Object)"destination_zone").add((Object)"event_action").add((Object)"event_source").add((Object)"event_source_api_version").add((Object)"event_source_product").add((Object)"event_code").add((Object)"event_error_code").add((Object)"event_error_description").add((Object)"event_log_name").add((Object)"event_reporter").add((Object)"event_uid").add((Object)"event_observer_uid").add((Object)"event_outcome").add((Object)"event_severity").add((Object)"email_message_id").add((Object)"email_subject").add((Object)"file_company").add((Object)"file_name").add((Object)"file_path").add((Object)"file_size").add((Object)"file_type").add((Object)"hash_md5").add((Object)"hash_sha1").add((Object)"hash_sha256").add((Object)"hash_sha512").add((Object)"hash_imphash").add((Object)"alert_definitions_version").add((Object)"alert_category").add((Object)"alert_indicator").add((Object)"alert_signature").add((Object)"alert_signature_id").add((Object)"alert_severity").add((Object)"associated_host").add((Object)"associated_mac").add((Object)"associated_hash").add((Object)"associated_category").add((Object)"associated_session_id").add((Object)"associated_user_id").add((Object)"service_version").add((Object)"service_name").add((Object)"vendor_alert_severity").add((Object)"vendor_event_action").add((Object)"vendor_event_description").add((Object)"vendor_event_outcome").add((Object)"vendor_event_outcome_reason").add((Object)"vendor_event_severity").add((Object)"vendor_signin_protocol").add((Object)"vendor_threat_suspected").add((Object)"vendor_transaction_id").add((Object)"vendor_transaction_type").add((Object)"vendor_user_type").add((Object)"windows_logon_type_description").add((Object)"windows_kerberos_encryption").add((Object)"windows_kerberos_encryption_type").add((Object)"windows_kerberos_service_name").add((Object)"windows_authentication_package_name").add((Object)"windows_authentication_lmpackage_name").add((Object)"windows_authentication_process_name").add((Object)"source_user_sid_authority1").add((Object)"source_user_sid_authority2").add((Object)"source_user_sid_rid").add((Object)"user_sid_authority1").add((Object)"user_sid_authority2").add((Object)"user_sid_rid").add((Object)"target_sid_authority1").add((Object)"target_sid_authority2").add((Object)"target_sid_rid").add((Object)"network_name").add((Object)"network_community_id").add((Object)"network_direction").add((Object)"network_icmp_type").add((Object)"network_ip_version").add((Object)"network_transport").add((Object)"network_tunnel_type").add((Object)"application_sso_signonmode").add((Object)"application_sso_target_name").add((Object)"threat_category").add((Object)"threat_detected").build();
    private static final Set<String> LOWERCASE_KEYWORD_FIELDS = ImmutableSet.builder().add((Object)"user_previous_name").add((Object)"previous_user_name").add((Object)"user_name_mapped").add((Object)"source_user_name_mapped").add((Object)"target_user_name_mapped").add((Object)"host_reference").add((Object)"host_hostname").add((Object)"host_virtfw_hostname").add((Object)"source_reference").add((Object)"source_hostname").add((Object)"destination_domain").add((Object)"destination_reference").add((Object)"destination_hostname").add((Object)"event_observer_hostname").add((Object)"associated_user_name").add((Object)"network_application").add((Object)"network_interface_in").add((Object)"network_interface_out").add((Object)"network_protocol").add((Object)"application_name").build();
    private static final Set<String> BYTE_FIELDS = ImmutableSet.builder().add((Object)"user_priority_level").add((Object)"source_user_priority_level").add((Object)"target_user_priority_level").add((Object)"host_priority_level").add((Object)"source_priority_level").add((Object)"destination_priority_level").add((Object)"event_severity_level").add((Object)"alert_severity_level").add((Object)"windows_logon_type").build();
    private static final Set<String> LONG_FIELDS = ImmutableSet.builder().add((Object)"http_bytes").add((Object)"http_request_bytes").add((Object)"http_response_bytes").add((Object)"http_url_length").add((Object)"http_user_agent_length").add((Object)"source_bytes_sent").add((Object)"source_packets").add((Object)"destination_bytes_sent").add((Object)"destination_packets_sent").add((Object)"event_duration").add((Object)"event_repeat_count").add((Object)"network_bytes").add((Object)"network_bytes_rx").add((Object)"network_bytes_tx").add((Object)"network_data_bytes").add((Object)"network_header_bytes").add((Object)"network_packets").add((Object)"network_tunnel_duration").build();
    private static final Set<String> INTEGER_FIELDS = ImmutableSet.builder().add((Object)"gl2_event_type_code").add((Object)"http_response_code").add((Object)"source_nat_port").add((Object)"destination_nat_port").add((Object)"destination_port").add((Object)"vendor_alert_severity_level").add((Object)"vendor_event_severity_level").add((Object)"network_iana_number").build();
    private static final Set<String> IP_FIELDS = ImmutableSet.builder().add((Object)"associated_ip").add((Object)"vendor_private_ip").add((Object)"vendor_private_ipv6").add((Object)"vendor_public_ip").add((Object)"vendor_public_ipv6").build();
    private static final Set<String> ASSOCIATED_IP_FIELDS = ImmutableSet.builder().add((Object)"host_ip").add((Object)"source_ip").add((Object)"source_nat_ip").add((Object)"destination_ip").add((Object)"destination_nat_ip").add((Object)"network_forwarded_ip").add((Object)"event_observer_ip").build();
    private static final Set<String> DATE_FIELDS = ImmutableSet.builder().add((Object)"event_created").add((Object)"event_start").add((Object)"event_received_time").add((Object)"file_created_date").build();

    @Override
    protected List<Map<String, Map<String, Object>>> dynamicTemplate() {
        return ImmutableList.builder().addAll(super.dynamicTemplate()).add(Collections.singletonMap("winlogbeat_fields", ImmutableMap.of((Object)"match", (Object)"winlogbeat_*", (Object)"match_mapping_type", (Object)"string", (Object)"mapping", Collections.singletonMap("type", "keyword")))).build();
    }

    private Map<String, Object> notAnalyzedString(Map<String, Object> settings) {
        return ImmutableMap.builder().putAll(this.notAnalyzedString()).putAll(settings).build();
    }

    private Map<String, Object> integerField() {
        return this.typeField("integer");
    }

    private Map<String, Map<String, Object>> toMapping(Set<String> fields, Supplier<Map<String, Object>> typeFunction) {
        return fields.stream().collect(Collectors.toMap(Function.identity(), field -> (Map)typeFunction.get()));
    }

    private Map<String, Object> notAnalyzedStringWithLowercaseNormalizer() {
        return this.notAnalyzedString(Collections.singletonMap("normalizer", "loweronly"));
    }

    private Map<String, Object> byteField() {
        return this.typeField("byte");
    }

    private Map<String, Object> longField() {
        return this.typeField("long");
    }

    private Map<String, Object> ipField() {
        return this.typeField("ip");
    }

    private Map<String, Object> dateField() {
        return this.merge(this.typeField("date"), Collections.singletonMap("format", this.dateFormats() + "||basic_date_time||basic_date_time_no_millis||epoch_second||date_time_no_millis||date_hour_minute_second_fraction||epoch_millis"));
    }

    protected abstract String dateFormats();

    private Map<String, Object> textField() {
        return this.typeField("text");
    }

    private Map<String, Object> typeField(String type) {
        return Collections.singletonMap("type", type);
    }

    private Map<String, Object> copyTo(Map<String, Object> source, String newField) {
        return this.merge(source, Collections.singletonMap("copy_to", newField));
    }

    private Map<String, Object> withAnalyzer(Map<String, Object> source, String analyzer) {
        return this.merge(source, Collections.singletonMap("analyzer", analyzer));
    }

    private Map<String, Object> merge(Map<String, Object> type1, Map<String, Object> type2) {
        return ImmutableMap.builder().putAll(type1).putAll(type2).build();
    }

    private Map<String, Object> settings() {
        return ImmutableMap.of((Object)"index.mapping.ignore_malformed", (Object)true, (Object)"analysis", (Object)ImmutableMap.of((Object)"normalizer", (Object)ImmutableMap.of((Object)"loweronly", (Object)ImmutableMap.of((Object)"type", (Object)"custom", (Object)"char_filter", Collections.emptyList(), (Object)"filter", Collections.singleton("lowercase"))), (Object)"analyzer", this.analyzerKeyword()));
    }

    @Override
    protected Map<String, Map<String, Object>> fieldProperties(String analyzer) {
        return ImmutableMap.builder().putAll(super.fieldProperties(analyzer)).putAll(this.toMapping(KEYWORD_FIELDS, this::notAnalyzedString)).putAll(this.toMapping(LOWERCASE_KEYWORD_FIELDS, this::notAnalyzedStringWithLowercaseNormalizer)).putAll(this.toMapping(BYTE_FIELDS, this::byteField)).putAll(this.toMapping(LONG_FIELDS, this::longField)).putAll(this.toMapping(INTEGER_FIELDS, this::integerField)).putAll(this.toMapping(IP_FIELDS, this::ipField)).putAll(this.toMapping(ASSOCIATED_IP_FIELDS, () -> this.copyTo(this.ipField(), "associated_ip"))).putAll(this.toMapping(DATE_FIELDS, this::dateField)).put((Object)"user_name", this.copyTo(this.notAnalyzedStringWithLowercaseNormalizer(), "associated_user_name")).put((Object)"source_user_name", this.copyTo(this.notAnalyzedStringWithLowercaseNormalizer(), "associated_user_name")).put((Object)"target_user_name", this.copyTo(this.notAnalyzedStringWithLowercaseNormalizer(), "associated_user_name")).put((Object)"source_user_session_id", this.copyTo(this.notAnalyzedString(), "associated_session_id")).put((Object)"target_user_session_id", this.copyTo(this.notAnalyzedString(), "associated_session_id")).put((Object)"session_id", this.copyTo(this.notAnalyzedString(), "associated_session_id")).put((Object)"user_session_id", this.copyTo(this.notAnalyzedString(), "associated_session_id")).put((Object)"http_headers", (Object)ImmutableMap.builder().putAll(this.withAnalyzer(this.textField(), "standard")).put((Object)"norms", (Object)false).put((Object)"index_options", (Object)"freqs").build()).put((Object)"http_user_agent_analyzed", this.withAnalyzer(this.textField(), "standard")).put((Object)"http_url_analyzed", this.withAnalyzer(this.textField(), "standard")).build();
    }

    @Override
    public Map<String, Object> messageTemplate(String template, String analyzer, int order) {
        return this.createTemplate(template, order, this.settings(), this.mapping(analyzer));
    }
}

