/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.indexer.results;

import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import com.google.common.collect.Range;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

final class HighlightParser {
    private static final String startToken = "<em>";
    private static final String endToken = "</em>";
    private static final Pattern highlightPattern = Pattern.compile("<em>(.*?)</em>");
    private static final Integer startTokenLength = "<em>".length();
    private static final Integer endTokenLength = "</em>".length();

    private HighlightParser() {
    }

    static Multimap<String, Range<Integer>> extractHighlightRanges(Map<String, List<String>> highlight) {
        if (highlight == null || highlight.isEmpty()) {
            return ImmutableListMultimap.of();
        }
        ImmutableListMultimap.Builder builder = ImmutableListMultimap.builder();
        highlight.forEach((key, value) -> HighlightParser.extractRange(value).forEach(range -> builder.put(key, range)));
        return builder.build();
    }

    private static Set<Range<Integer>> extractRange(List<String> highlights) {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        highlights.forEach(highlight -> {
            Matcher matcher = highlightPattern.matcher((CharSequence)highlight);
            Integer count = -1;
            while (matcher.find()) {
                Integer n = count;
                Integer n2 = count = Integer.valueOf(count + 1);
                Integer start = matcher.start() - count * (startTokenLength + endTokenLength);
                Integer end = start + (matcher.end(1) - matcher.start(1));
                builder.add((Object)Range.closed((Comparable)start, (Comparable)end));
            }
        });
        return builder.build();
    }
}

