/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.web;

import com.floreysoft.jmte.Engine;
import com.google.common.collect.ImmutableMap;
import com.google.common.io.Resources;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.ws.rs.core.MultivaluedMap;
import org.graylog2.configuration.HttpConfiguration;
import org.graylog2.rest.RestTools;
import org.graylog2.web.IndexHtmlGenerator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class DevelopmentIndexHtmlGenerator
implements IndexHtmlGenerator {
    private static final Logger LOG = LoggerFactory.getLogger(DevelopmentIndexHtmlGenerator.class);
    private static final String TEMPLATE_RESOURCE = "web-interface/index.html.development.template";
    private final Engine templateEngine;
    private final HttpConfiguration httpConfiguration;

    @Inject
    public DevelopmentIndexHtmlGenerator(Engine templateEngine, HttpConfiguration httpConfiguration) {
        this.templateEngine = templateEngine;
        this.httpConfiguration = httpConfiguration;
    }

    @Override
    public String get(MultivaluedMap<String, String> headers) {
        URI relativePath = RestTools.buildRelativeExternalUri(headers, this.httpConfiguration.getHttpExternalUri());
        ImmutableMap model = ImmutableMap.builder().put((Object)"title", (Object)"Graylog DEVELOPMENT Web Interface").put((Object)"appPrefix", (Object)relativePath).build();
        return this.templateEngine.transform(this.getTemplate(), (Map)model);
    }

    private String getTemplate() {
        try {
            return Resources.toString((URL)Resources.getResource((String)TEMPLATE_RESOURCE), (Charset)StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            LOG.error("Couldn't load template resource <{}>", (Object)TEMPLATE_RESOURCE, (Object)e);
            return "MISSING TEMPLATE -- THIS IS A BUG!";
        }
    }
}

