/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2;

import com.github.joschi.jadconfig.Parameter;
import com.github.joschi.jadconfig.ValidationException;
import com.github.joschi.jadconfig.Validator;
import com.github.joschi.jadconfig.ValidatorMethod;
import com.github.joschi.jadconfig.converters.StringSetConverter;
import com.github.joschi.jadconfig.converters.TrimmedStringSetConverter;
import com.github.joschi.jadconfig.util.Duration;
import com.github.joschi.jadconfig.validators.PositiveDurationValidator;
import com.github.joschi.jadconfig.validators.PositiveIntegerValidator;
import com.github.joschi.jadconfig.validators.PositiveLongValidator;
import com.github.joschi.jadconfig.validators.StringNotBlankValidator;
import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.Set;
import org.graylog2.plugin.BaseConfiguration;
import org.graylog2.utilities.IPSubnetConverter;
import org.graylog2.utilities.IpSubnet;
import org.joda.time.DateTimeZone;

public class Configuration
extends BaseConfiguration {
    @Parameter(value="is_master", required=true)
    private boolean isMaster = true;
    @Parameter(value="password_secret", required=true, validator=StringNotBlankValidator.class)
    private String passwordSecret;
    @Parameter(value="output_batch_size", required=true, validator=PositiveIntegerValidator.class)
    private int outputBatchSize = 500;
    @Parameter(value="output_flush_interval", required=true, validator=PositiveIntegerValidator.class)
    private int outputFlushInterval = 1;
    @Parameter(value="outputbuffer_processors", required=true, validator=PositiveIntegerValidator.class)
    private int outputBufferProcessors = 3;
    @Parameter(value="outputbuffer_processor_threads_max_pool_size", required=true, validator=PositiveIntegerValidator.class)
    private int outputBufferProcessorThreadsMaxPoolSize = 30;
    @Parameter(value="outputbuffer_processor_threads_core_pool_size", required=true, validator=PositiveIntegerValidator.class)
    private int outputBufferProcessorThreadsCorePoolSize = 3;
    @Parameter(value="outputbuffer_processor_keep_alive_time", validator=PositiveIntegerValidator.class)
    private int outputBufferProcessorKeepAliveTime = 5000;
    @Parameter(value="node_id_file", validator=NodeIdFileValidator.class)
    private String nodeIdFile = "/etc/graylog/server/node-id";
    @Parameter(value="root_username")
    private String rootUsername = "admin";
    @Parameter(value="root_password_sha2")
    private String rootPasswordSha2;
    @Parameter(value="root_timezone")
    private DateTimeZone rootTimeZone = DateTimeZone.UTC;
    @Parameter(value="root_email")
    private String rootEmail = "";
    @Parameter(value="allow_leading_wildcard_searches")
    private boolean allowLeadingWildcardSearches = false;
    @Parameter(value="allow_highlighting")
    private boolean allowHighlighting = false;
    @Parameter(value="lb_recognition_period_seconds", validator=PositiveIntegerValidator.class)
    private int loadBalancerRecognitionPeriodSeconds = 3;
    @Parameter(value="lb_throttle_threshold_percentage", validator=PositiveIntegerValidator.class)
    private int loadBalancerThrottleThresholdPercentage = 100;
    @Parameter(value="stream_processing_timeout", validator=PositiveLongValidator.class)
    private long streamProcessingTimeout = 2000L;
    @Parameter(value="stream_processing_max_faults", validator=PositiveIntegerValidator.class)
    private int streamProcessingMaxFaults = 3;
    @Parameter(value="output_module_timeout", validator=PositiveLongValidator.class)
    private long outputModuleTimeout = 10000L;
    @Parameter(value="output_fault_count_threshold", validator=PositiveLongValidator.class)
    private long outputFaultCountThreshold = 5L;
    @Parameter(value="output_fault_penalty_seconds", validator=PositiveLongValidator.class)
    private long outputFaultPenaltySeconds = 30L;
    @Parameter(value="stale_master_timeout", validator=PositiveIntegerValidator.class)
    private int staleMasterTimeout = 2000;
    @Parameter(value="ldap_connection_timeout", validator=PositiveIntegerValidator.class)
    private int ldapConnectionTimeout = 2000;
    @Parameter(value="alert_check_interval", validator=PositiveIntegerValidator.class)
    @Deprecated
    private int alertCheckInterval = 60;
    @Parameter(value="enable_legacy_alerts")
    @Deprecated
    private boolean enableLegacyAlerts = false;
    @Parameter(value="gc_warning_threshold")
    private Duration gcWarningThreshold = Duration.seconds((long)1L);
    @Parameter(value="default_message_output_class")
    private String defaultMessageOutputClass = "";
    @Parameter(value="dashboard_widget_default_cache_time", validator=PositiveDurationValidator.class)
    private Duration dashboardWidgetDefaultCacheTime = Duration.seconds((long)10L);
    @Parameter(value="user_password_default_algorithm")
    private String userPasswordDefaultAlgorithm = "bcrypt";
    @Parameter(value="user_password_bcrypt_salt_size", validator=PositiveIntegerValidator.class)
    private int userPasswordBCryptSaltSize = 10;
    @Parameter(value="content_packs_loader_enabled")
    private boolean contentPacksLoaderEnabled = false;
    @Parameter(value="content_packs_dir")
    private Path contentPacksDir = DEFAULT_DATA_DIR.resolve("contentpacks");
    @Parameter(value="content_packs_auto_install", converter=TrimmedStringSetConverter.class)
    private Set<String> contentPacksAutoInstall = Collections.emptySet();
    @Parameter(value="index_ranges_cleanup_interval", validator=PositiveDurationValidator.class)
    private Duration indexRangesCleanupInterval = Duration.hours((long)1L);
    @Parameter(value="trusted_proxies", converter=IPSubnetConverter.class)
    private Set<IpSubnet> trustedProxies = Collections.emptySet();
    @Parameter(value="deactivated_builtin_authentication_providers", converter=StringSetConverter.class)
    private Set<String> deactivatedBuiltinAuthenticationProviders = Collections.emptySet();
    @Parameter(value="enabled_tls_protocols", converter=StringSetConverter.class)
    private Set<String> enabledTlsProtocols = null;
    @Parameter(value="is_cloud")
    private boolean isCloud = false;

    public boolean isMaster() {
        return this.isMaster;
    }

    public void setIsMaster(boolean is) {
        this.isMaster = is;
    }

    public String getPasswordSecret() {
        return this.passwordSecret.trim();
    }

    public int getOutputBatchSize() {
        return this.outputBatchSize;
    }

    public int getOutputFlushInterval() {
        return this.outputFlushInterval;
    }

    public int getOutputBufferProcessors() {
        return this.outputBufferProcessors;
    }

    public int getOutputBufferProcessorThreadsCorePoolSize() {
        return this.outputBufferProcessorThreadsCorePoolSize;
    }

    public int getOutputBufferProcessorThreadsMaxPoolSize() {
        return this.outputBufferProcessorThreadsMaxPoolSize;
    }

    public int getOutputBufferProcessorKeepAliveTime() {
        return this.outputBufferProcessorKeepAliveTime;
    }

    public boolean isCloud() {
        return this.isCloud;
    }

    @Override
    public String getNodeIdFile() {
        return this.nodeIdFile;
    }

    public String getRootUsername() {
        return this.rootUsername;
    }

    public String getRootPasswordSha2() {
        return this.rootPasswordSha2;
    }

    public DateTimeZone getRootTimeZone() {
        return this.rootTimeZone;
    }

    public String getRootEmail() {
        return this.rootEmail;
    }

    public boolean isAllowLeadingWildcardSearches() {
        return this.allowLeadingWildcardSearches;
    }

    public boolean isAllowHighlighting() {
        return this.allowHighlighting;
    }

    public int getLoadBalancerRecognitionPeriodSeconds() {
        return this.loadBalancerRecognitionPeriodSeconds;
    }

    public long getStreamProcessingTimeout() {
        return this.streamProcessingTimeout;
    }

    public int getStreamProcessingMaxFaults() {
        return this.streamProcessingMaxFaults;
    }

    public long getOutputModuleTimeout() {
        return this.outputModuleTimeout;
    }

    public long getOutputFaultCountThreshold() {
        return this.outputFaultCountThreshold;
    }

    public long getOutputFaultPenaltySeconds() {
        return this.outputFaultPenaltySeconds;
    }

    public int getStaleMasterTimeout() {
        return this.staleMasterTimeout;
    }

    public int getLdapConnectionTimeout() {
        return this.ldapConnectionTimeout;
    }

    @Deprecated
    public int getAlertCheckInterval() {
        return this.alertCheckInterval;
    }

    @Deprecated
    public boolean isEnableLegacyAlerts() {
        return this.enableLegacyAlerts;
    }

    public Duration getGcWarningThreshold() {
        return this.gcWarningThreshold;
    }

    public String getDefaultMessageOutputClass() {
        return this.defaultMessageOutputClass;
    }

    public Duration getDashboardWidgetDefaultCacheTime() {
        return this.dashboardWidgetDefaultCacheTime;
    }

    public String getUserPasswordDefaultAlgorithm() {
        return this.userPasswordDefaultAlgorithm;
    }

    public int getUserPasswordBCryptSaltSize() {
        return this.userPasswordBCryptSaltSize;
    }

    public boolean isContentPacksLoaderEnabled() {
        return this.contentPacksLoaderEnabled;
    }

    public Path getContentPacksDir() {
        return this.contentPacksDir;
    }

    public Set<String> getContentPacksAutoInstall() {
        return this.contentPacksAutoInstall;
    }

    public Duration getIndexRangesCleanupInterval() {
        return this.indexRangesCleanupInterval;
    }

    public Set<IpSubnet> getTrustedProxies() {
        return this.trustedProxies;
    }

    public int getLoadBalancerRequestThrottleJournalUsage() {
        return this.loadBalancerThrottleThresholdPercentage;
    }

    public Set<String> getDeactivatedBuiltinAuthenticationProviders() {
        return this.deactivatedBuiltinAuthenticationProviders;
    }

    @Deprecated
    public Set<String> getEnabledTlsProtocols() {
        return this.enabledTlsProtocols;
    }

    @ValidatorMethod
    public void validatePasswordSecret() throws ValidationException {
        String passwordSecret = this.getPasswordSecret();
        if (passwordSecret == null || passwordSecret.length() < 16) {
            throw new ValidationException("The minimum length for \"password_secret\" is 16 characters.");
        }
    }

    @ValidatorMethod
    public void validateRootUser() throws ValidationException {
        if (this.getRootPasswordSha2() == null && !this.isRootUserDisabled()) {
            throw new ValidationException("Required parameter \"root_password_sha2\" not found.");
        }
    }

    public boolean isRootUserDisabled() {
        return this.getDeactivatedBuiltinAuthenticationProviders().contains("root-user");
    }

    public static class NodeIdFileValidator
    implements Validator<String> {
        public void validate(String name, String path) throws ValidationException {
            boolean empty;
            if (path == null) {
                return;
            }
            File file = Paths.get(path, new String[0]).toFile();
            StringBuilder b = new StringBuilder();
            if (!file.exists()) {
                File parent = file.getParentFile();
                if (!parent.isDirectory()) {
                    throw new ValidationException("Parent path " + parent + " for Node ID file at " + path + " is not a directory");
                }
                if (!parent.canRead()) {
                    throw new ValidationException("Parent directory " + parent + " for Node ID file at " + path + " is not readable");
                }
                if (!parent.canWrite()) {
                    throw new ValidationException("Parent directory " + parent + " for Node ID file at " + path + " is not writable");
                }
                return;
            }
            if (!file.isFile()) {
                b.append("a file");
            }
            boolean readable = file.canRead();
            boolean writable = file.canWrite();
            if (!readable) {
                if (b.length() > 0) {
                    b.append(", ");
                }
                b.append("readable");
            }
            boolean bl = empty = file.length() == 0L;
            if (!writable && readable && empty) {
                if (b.length() > 0) {
                    b.append(", ");
                }
                b.append("writable, but it is empty");
            }
            if (b.length() == 0) {
                return;
            }
            throw new ValidationException("Node ID file at path " + path + " isn't " + b + ". Please specify the correct path or change the permissions");
        }
    }
}

