/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.rest.resources.search;

import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.ws.rs.BadRequestException;
import javax.ws.rs.ForbiddenException;
import org.glassfish.jersey.server.ChunkedOutput;
import org.graylog2.decorators.DecoratorProcessor;
import org.graylog2.indexer.ranges.IndexRange;
import org.graylog2.indexer.results.ResultMessage;
import org.graylog2.indexer.results.ScrollResult;
import org.graylog2.indexer.results.SearchResult;
import org.graylog2.indexer.searches.Searches;
import org.graylog2.indexer.searches.SearchesClusterConfig;
import org.graylog2.indexer.searches.Sorting;
import org.graylog2.plugin.cluster.ClusterConfigService;
import org.graylog2.plugin.indexer.searches.timeranges.AbsoluteRange;
import org.graylog2.plugin.indexer.searches.timeranges.TimeRange;
import org.graylog2.rest.models.messages.responses.ResultMessageSummary;
import org.graylog2.rest.models.system.indexer.responses.IndexRangeSummary;
import org.graylog2.rest.resources.search.responses.SearchResponse;
import org.graylog2.shared.rest.resources.RestResource;
import org.joda.time.DateTime;
import org.joda.time.Period;
import org.joda.time.ReadableInstant;
import org.joda.time.ReadablePeriod;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class SearchResource
extends RestResource {
    private static final Logger LOG = LoggerFactory.getLogger(SearchResource.class);
    protected static final String DEFAULT_SCROLL_BATCH_SIZE = "500";
    protected final Searches searches;
    private final ClusterConfigService clusterConfigService;
    private final DecoratorProcessor decoratorProcessor;

    public SearchResource(Searches searches, ClusterConfigService clusterConfigService, DecoratorProcessor decoratorProcessor) {
        this.searches = searches;
        this.clusterConfigService = clusterConfigService;
        this.decoratorProcessor = decoratorProcessor;
    }

    protected List<String> parseFields(String fields) {
        if (Strings.isNullOrEmpty((String)fields)) {
            LOG.warn("Missing fields parameter. Returning HTTP 400");
            throw new BadRequestException("Missing required parameter `fields`");
        }
        return this.parseOptionalFields(fields);
    }

    protected List<String> parseOptionalFields(String fields) {
        if (Strings.isNullOrEmpty((String)fields)) {
            return null;
        }
        Iterable split = Splitter.on((char)',').omitEmptyStrings().trimResults().split((CharSequence)fields);
        ArrayList fieldList = Lists.newArrayList((Object[])new String[]{"timestamp"});
        for (String field : split) {
            if ("timestamp".equals(field)) continue;
            fieldList.add(field);
        }
        return fieldList;
    }

    protected SearchResponse buildSearchResponse(SearchResult sr, TimeRange timeRange, boolean decorate, Optional<String> streamId) {
        SearchResponse result = SearchResponse.create(sr.getOriginalQuery(), sr.getBuiltQuery(), this.indexRangeListToValueList(sr.getUsedIndices()), this.resultMessageListtoValueList(sr.getResults()), sr.getFields(), sr.tookMs(), sr.getTotalResults(), timeRange.getFrom(), timeRange.getTo());
        return decorate ? this.decoratorProcessor.decorate(result, streamId) : result;
    }

    protected Set<IndexRangeSummary> indexRangeListToValueList(Set<IndexRange> indexRanges) {
        HashSet result = Sets.newHashSetWithExpectedSize((int)indexRanges.size());
        for (IndexRange indexRange : indexRanges) {
            result.add(IndexRangeSummary.create(indexRange.indexName(), indexRange.begin(), indexRange.end(), indexRange.calculatedAt(), indexRange.calculationDuration()));
        }
        return result;
    }

    protected List<ResultMessageSummary> resultMessageListtoValueList(List<ResultMessage> resultMessages) {
        return resultMessages.stream().map(resultMessage -> ResultMessageSummary.create(resultMessage.highlightRanges, resultMessage.getMessage().getFields(), resultMessage.getIndex())).collect(Collectors.toList());
    }

    protected Sorting buildSorting(String sort) {
        if (Strings.isNullOrEmpty((String)sort)) {
            return Sorting.DEFAULT;
        }
        try {
            return Sorting.fromApiParam(sort);
        }
        catch (Exception e) {
            LOG.error("Falling back to default sorting.", (Throwable)e);
            return Sorting.DEFAULT;
        }
    }

    protected ChunkedOutput<ScrollResult.ScrollChunk> buildChunkedOutput(ScrollResult scroll) {
        ChunkedOutput output = new ChunkedOutput(ScrollResult.ScrollChunk.class);
        LOG.debug("[{}] Scroll result contains a total of {} messages", (Object)scroll.getQueryHash(), (Object)scroll.totalHits());
        Runnable scrollIterationAction = this.createScrollChunkProducer(scroll, (ChunkedOutput<ScrollResult.ScrollChunk>)output);
        new Thread(scrollIterationAction).start();
        return output;
    }

    public void checkSearchPermission(String filter, String searchPermission) {
        if (Strings.isNullOrEmpty((String)filter) || "*".equals(filter)) {
            this.checkPermission(searchPermission);
        } else {
            if (!filter.startsWith("streams:")) {
                throw new ForbiddenException("Not allowed to search with filter: [" + filter + "]");
            }
            String[] parts = filter.split(":");
            if (parts.length <= 1) {
                throw new ForbiddenException("Not allowed to search with filter: [" + filter + "]");
            }
            String streamList = parts[1];
            String[] streams = streamList.split(",");
            if (streams.length == 0) {
                throw new ForbiddenException("Not allowed to search with filter: [" + filter + "]");
            }
            for (String streamId : streams) {
                if (this.isPermitted("streams:read", streamId)) continue;
                String msg = "Not allowed to search with filter: [" + filter + "]. (Forbidden stream: " + streamId + ")";
                LOG.warn(msg);
                throw new ForbiddenException(msg);
            }
        }
    }

    protected Runnable createScrollChunkProducer(ScrollResult scroll, ChunkedOutput<ScrollResult.ScrollChunk> output) {
        return () -> {
            try {
                ScrollResult.ScrollChunk chunk = scroll.nextChunk();
                while (chunk != null) {
                    LOG.debug("[{}] Writing scroll chunk with {} messages", (Object)scroll.getQueryHash(), (Object)chunk.getMessages().size());
                    if (output.isClosed()) {
                        LOG.debug("[{}] Client connection is closed, client disconnected. Aborting scroll.", (Object)scroll.getQueryHash());
                        scroll.cancel();
                        return;
                    }
                    output.write((Object)chunk);
                    chunk = scroll.nextChunk();
                }
                LOG.debug("[{}] Reached end of scroll result.", (Object)scroll.getQueryHash());
                output.close();
            }
            catch (IOException e) {
                LOG.warn("[{}] Could not close chunked output stream for query scroll.", (Object)scroll.getQueryHash());
            }
        };
    }

    protected TimeRange restrictTimeRange(TimeRange timeRange) {
        DateTime limitedFrom;
        DateTime originalFrom = timeRange.getFrom();
        DateTime to = timeRange.getTo();
        SearchesClusterConfig config = this.clusterConfigService.get(SearchesClusterConfig.class);
        DateTime from = config == null || Period.ZERO.equals((Object)config.queryTimeRangeLimit()) ? originalFrom : ((limitedFrom = to.minus((ReadablePeriod)config.queryTimeRangeLimit())).isAfter((ReadableInstant)originalFrom) ? limitedFrom : originalFrom);
        return AbsoluteRange.create(from, to);
    }
}

