/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.rest.resources.system;

import com.codahale.metrics.annotation.Timed;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import javax.inject.Inject;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.apache.shiro.authz.annotation.RequiresAuthentication;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.graylog2.audit.jersey.AuditEvent;
import org.graylog2.audit.jersey.NoAuditEvent;
import org.graylog2.rest.models.system.urlwhitelist.WhitelistCheckRequest;
import org.graylog2.rest.models.system.urlwhitelist.WhitelistCheckResponse;
import org.graylog2.rest.models.system.urlwhitelist.WhitelistRegexGenerationRequest;
import org.graylog2.rest.models.system.urlwhitelist.WhitelistRegexGenerationResponse;
import org.graylog2.shared.rest.resources.RestResource;
import org.graylog2.system.urlwhitelist.RegexHelper;
import org.graylog2.system.urlwhitelist.UrlWhitelist;
import org.graylog2.system.urlwhitelist.UrlWhitelistService;

@RequiresAuthentication
@Api(value="System/UrlWhitelist")
@Path(value="/system/urlwhitelist")
@Produces(value={"application/json"})
public class UrlWhitelistResource
extends RestResource {
    private final UrlWhitelistService urlWhitelistService;
    private final RegexHelper regexHelper;

    @Inject
    public UrlWhitelistResource(UrlWhitelistService urlWhitelistService, RegexHelper regexHelper) {
        this.urlWhitelistService = urlWhitelistService;
        this.regexHelper = regexHelper;
    }

    @GET
    @Timed
    @ApiOperation(value="Get url whitelist.")
    @RequiresPermissions(value={"urlwhitelist:read"})
    public UrlWhitelist get() {
        this.checkPermission("urlwhitelist:read");
        return this.urlWhitelistService.getWhitelist();
    }

    @PUT
    @Timed
    @ApiOperation(value="Update url whitelist.")
    @AuditEvent(type="server:url_whitelist:update")
    @Consumes(value={"application/json"})
    @RequiresPermissions(value={"urlwhitelist:write"})
    public Response put(@ApiParam(name="whitelist", required=true) @NotNull UrlWhitelist whitelist) {
        this.urlWhitelistService.saveWhitelist(whitelist);
        return Response.noContent().build();
    }

    @POST
    @Path(value="/check")
    @Timed
    @ApiOperation(value="Check if a url is whitelisted.")
    @NoAuditEvent(value="Validation only")
    @Consumes(value={"application/json"})
    public WhitelistCheckResponse check(@ApiParam(name="JSON body", required=true) @Valid @NotNull WhitelistCheckRequest checkRequest) {
        boolean isWhitelisted = this.urlWhitelistService.isWhitelisted(checkRequest.url());
        return WhitelistCheckResponse.create(checkRequest.url(), isWhitelisted);
    }

    @POST
    @Path(value="/generate_regex")
    @Timed
    @ApiOperation(value="Generates a regex that can be used as a value for a whitelist entry.")
    @NoAuditEvent(value="Utility function only.")
    @Consumes(value={"application/json"})
    public WhitelistRegexGenerationResponse generateRegex(@ApiParam(name="JSON body", required=true) @Valid @NotNull WhitelistRegexGenerationRequest generationRequest) {
        String regex = generationRequest.placeholder() == null ? this.regexHelper.createRegexForUrl(generationRequest.urlTemplate()) : this.regexHelper.createRegexForUrlTemplate(generationRequest.urlTemplate(), generationRequest.placeholder());
        return WhitelistRegexGenerationResponse.create(regex);
    }
}

