/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.shared.security;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Priority;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.ws.rs.BadRequestException;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.SecurityContext;
import org.apache.shiro.authc.AuthenticationToken;
import org.apache.shiro.authc.UsernamePasswordToken;
import org.apache.shiro.mgt.DefaultSecurityManager;
import org.apache.shiro.mgt.SecurityManager;
import org.apache.shiro.subject.Subject;
import org.glassfish.grizzly.http.server.Request;
import org.graylog2.rest.RestTools;
import org.graylog2.shared.security.AccessTokenAuthToken;
import org.graylog2.shared.security.HttpHeadersToken;
import org.graylog2.shared.security.SessionIdToken;
import org.graylog2.shared.security.ShiroSecurityContext;
import org.graylog2.utilities.IpSubnet;

@Priority(value=990)
public class ShiroSecurityContextFilter
implements ContainerRequestFilter {
    private final DefaultSecurityManager securityManager;
    private Provider<Request> grizzlyRequestProvider;
    private final Set<IpSubnet> trustedProxies;

    @Inject
    public ShiroSecurityContextFilter(DefaultSecurityManager securityManager, Provider<Request> grizzlyRequestProvider, @Named(value="trusted_proxies") Set<IpSubnet> trustedProxies) {
        this.securityManager = Objects.requireNonNull(securityManager);
        this.grizzlyRequestProvider = grizzlyRequestProvider;
        this.trustedProxies = trustedProxies;
    }

    public void filter(ContainerRequestContext requestContext) throws IOException {
        SecurityContext securityContext;
        boolean secure = requestContext.getSecurityContext().isSecure();
        MultivaluedMap headers = requestContext.getHeaders();
        Request grizzlyRequest = (Request)this.grizzlyRequestProvider.get();
        String host = RestTools.getRemoteAddrFromRequest(grizzlyRequest, this.trustedProxies);
        String authHeader = (String)headers.getFirst((Object)"Authorization");
        if (authHeader != null && authHeader.startsWith("Basic")) {
            String base64UserPass = authHeader.substring(authHeader.indexOf(32) + 1);
            String userPass = this.decodeBase64(base64UserPass);
            String[] split = userPass.split(":", 2);
            if (split.length != 2) {
                throw new BadRequestException("Invalid credentials in Authorization header");
            }
            securityContext = this.createSecurityContext(split[0], split[1], secure, "BASIC", host, grizzlyRequest.getRemoteAddr(), (MultivaluedMap<String, String>)headers);
        } else {
            securityContext = this.createSecurityContext(null, null, secure, null, host, grizzlyRequest.getRemoteAddr(), (MultivaluedMap<String, String>)headers);
        }
        requestContext.setSecurityContext(securityContext);
    }

    private String decodeBase64(String s) {
        try {
            return new String(Base64.getDecoder().decode(s), StandardCharsets.US_ASCII);
        }
        catch (IllegalArgumentException e) {
            return "";
        }
    }

    private SecurityContext createSecurityContext(String userName, String credential, boolean isSecure, String authcScheme, String host, String remoteAddr, MultivaluedMap<String, String> headers) {
        Object authToken = "session".equalsIgnoreCase(credential) ? ("undefined".equalsIgnoreCase(userName) ? new HttpHeadersToken(headers, host, remoteAddr) : new SessionIdToken(userName, host)) : ("token".equalsIgnoreCase(credential) ? new AccessTokenAuthToken(userName, host) : (userName == null ? new HttpHeadersToken(headers, host, remoteAddr) : new UsernamePasswordToken(userName, credential, host)));
        Subject subject = new Subject.Builder((SecurityManager)this.securityManager).host(host).sessionCreationEnabled(true).buildSubject();
        return new ShiroSecurityContext(subject, (AuthenticationToken)authToken, isSecure, authcScheme, headers);
    }
}

