/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.featureflag;

import com.codahale.metrics.Counter;
import com.codahale.metrics.MetricRegistry;
import java.util.Map;
import java.util.stream.Collectors;
import org.graylog2.featureflag.FeatureFlagStringUtil;
import org.graylog2.featureflag.FeatureFlags;
import org.graylog2.shared.metrics.MetricUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ImmutableFeatureFlags
implements FeatureFlags {
    private static final Logger LOG = LoggerFactory.getLogger(ImmutableFeatureFlags.class);
    private final Map<String, FeatureFlag> flags;

    public ImmutableFeatureFlags(Map<String, String> flags, MetricRegistry metricRegistry) {
        this.flags = flags.entrySet().stream().collect(Collectors.toMap(e -> FeatureFlagStringUtil.toUpperCase((String)e.getKey()), e -> new FeatureFlag((String)e.getKey(), (String)e.getValue(), metricRegistry)));
    }

    @Override
    public Map<String, String> getAll() {
        return this.flags.values().stream().collect(Collectors.toMap(flag -> ((FeatureFlag)flag).name, flag -> ((FeatureFlag)flag).value));
    }

    @Override
    public boolean isOn(String feature) {
        FeatureFlag flag = this.getFlag(feature);
        if (flag == null) {
            LOG.warn("Feature flag '{}' is not set. Fall back to default value 'false'", (Object)feature);
            return false;
        }
        return flag.isOn();
    }

    @Override
    public void incrementFeatureIsUsedCounter(String feature) {
        FeatureFlag flag = this.getFlag(feature);
        if (flag != null) {
            flag.incrementFeatureIsUsedCounter();
        } else {
            LOG.warn("Feature flag '{}' don't exist! Could not update metric!", (Object)feature);
        }
    }

    private FeatureFlag getFlag(String feature) {
        return this.flags.get(FeatureFlagStringUtil.toUpperCase(feature));
    }

    private static class FeatureFlag {
        private static final String ON = "ON";
        private static final String VALID_METRIC_NAME_PATTERN = "[a-zA-Z_][a-zA-Z0-9_]*";
        private Counter featureUsedCounter;
        private Counter featureFlagUsedCounter;
        private final String name;
        private final String value;

        FeatureFlag(String name, String state, MetricRegistry metricRegistry) {
            this.name = name;
            this.value = state;
            if (this.validMetricName(name)) {
                this.initMetrics(name, state, metricRegistry);
            } else {
                LOG.warn("Metrics for feature flag '{}' can not be collected! Invalid characters.", (Object)name);
            }
        }

        private boolean validMetricName(String name) {
            return name.matches(VALID_METRIC_NAME_PATTERN);
        }

        private void initMetrics(String name, String state, MetricRegistry metricRegistry) {
            this.featureUsedCounter = metricRegistry.counter(FeatureFlagStringUtil.stringFormat("org.graylog.feature.used.%s", name));
            this.featureFlagUsedCounter = metricRegistry.counter(FeatureFlagStringUtil.stringFormat("org.graylog.featureflag.used.%s", name));
            MetricUtils.getOrRegister(metricRegistry, FeatureFlagStringUtil.stringFormat("org.graylog.featureflag.state.%s.%s", name, state), () -> 0);
        }

        boolean isOn() {
            this.incrementCounter(this.featureFlagUsedCounter);
            return ON.equalsIgnoreCase(this.value);
        }

        void incrementFeatureIsUsedCounter() {
            this.incrementCounter(this.featureUsedCounter);
        }

        private void incrementCounter(Counter counter) {
            if (counter != null) {
                counter.inc();
            }
        }
    }
}

