/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.featureflag;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.graylog2.featureflag.FeatureFlagStringUtil;
import org.graylog2.featureflag.FeatureFlagsResources;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ImmutableFeatureFlagsCollector {
    private static final Logger LOG = LoggerFactory.getLogger(ImmutableFeatureFlagsCollector.class);
    private static final String GRAYLOG_FF_ENVIRONMENT_VAR_PREFIX = "GRAYLOG_FEATURE_";
    private static final String GRAYLOG_FF_SYSTEM_PROP_PREFIX = "graylog.feature.";
    private Map<String, FeatureFlagValue> existingFlags = new HashMap<String, FeatureFlagValue>();
    private final FeatureFlagsResources resources;
    private final String defaultPropertiesFile;
    private final String customPropertiesFile;

    public ImmutableFeatureFlagsCollector(FeatureFlagsResources resources, String defaultPropertiesFile, String customPropertiesFile) {
        this.resources = resources;
        this.defaultPropertiesFile = defaultPropertiesFile;
        this.customPropertiesFile = customPropertiesFile;
    }

    public Map<String, String> toMap() {
        this.existingFlags = new HashMap<String, FeatureFlagValue>();
        Map<String, String> defaultPropertiesFlags = this.getDefaultPropertiesFlags(this.defaultPropertiesFile);
        this.addFlags(defaultPropertiesFlags, "default properties file");
        this.addCustomPropertiesFlags(this.customPropertiesFile);
        this.addSystemPropertiesFlags();
        this.addEnvironmentVariableFlags();
        this.logUsedFeatureFlags();
        this.logWarningForNoDefaultFlags(defaultPropertiesFlags.keySet());
        return this.existingFlags.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> ((FeatureFlagValue)e.getValue()).value));
    }

    private void logWarningForNoDefaultFlags(Collection<String> defaultFlags) {
        Map<String, List<Map.Entry>> flagsWithoutDefault = this.existingFlags.entrySet().stream().filter(e -> !defaultFlags.contains(e.getKey())).collect(Collectors.groupingBy(e -> ((FeatureFlagValue)e.getValue()).resourceType));
        if (!flagsWithoutDefault.isEmpty()) {
            LOG.warn("Following feature flags have no entry in the default config file: {}", flagsWithoutDefault);
        }
    }

    private void logUsedFeatureFlags() {
        LOG.info("Following feature flags are used: {}", this.existingFlags.entrySet().stream().collect(Collectors.groupingBy(e -> ((FeatureFlagValue)e.getValue()).resourceType)));
    }

    private Map<String, String> getDefaultPropertiesFlags(String file) {
        try {
            return this.resources.defaultProperties(file);
        }
        catch (IOException e) {
            throw new RuntimeException(FeatureFlagStringUtil.stringFormat("Unable to read default feature flags file %s!", file), e);
        }
    }

    private void addCustomPropertiesFlags(String file) {
        try {
            this.addFlags(this.resources.customProperties(file), "custom properties file");
        }
        catch (IOException e) {
            LOG.debug("Unable to read custom feature flags file {}! Skipping...", (Object)file);
        }
    }

    private void addSystemPropertiesFlags() {
        this.addFlagsWithPrefix(GRAYLOG_FF_SYSTEM_PROP_PREFIX, this.resources.systemProperties(), "system properties");
    }

    private void addEnvironmentVariableFlags() {
        this.addFlagsWithPrefix(GRAYLOG_FF_ENVIRONMENT_VAR_PREFIX, this.resources.environmentVariables(), "environment variables");
    }

    private void addFlagsWithPrefix(String prefix, Map<String, String> newFlags, String resourceType) {
        this.addFlags(newFlags, resourceType, s -> FeatureFlagStringUtil.startsWithIgnoreCase(s, prefix), s -> s.substring(prefix.length()));
    }

    private void addFlags(Map<String, String> newFlags, String resourceType) {
        this.addFlags(newFlags, resourceType, s -> true, Function.identity());
    }

    private void addFlags(Map<String, String> newFlags, String resourceType, Predicate<String> predicate, Function<String, String> transform) {
        ArrayListMultimap possibleDuplicates = ArrayListMultimap.create();
        for (Map.Entry<String, String> entry : newFlags.entrySet()) {
            if (!predicate.test(entry.getKey())) continue;
            String key = transform.apply(entry.getKey());
            this.addFlag(key, entry.getValue(), resourceType);
            possibleDuplicates.put((Object)FeatureFlagStringUtil.toUpperCase(key), (Object)key);
        }
        this.checkForDuplicates((Multimap<String, String>)possibleDuplicates, resourceType);
    }

    private void checkForDuplicates(Multimap<String, String> possibleDuplicates, String source) {
        List duplicates = possibleDuplicates.asMap().values().stream().filter(collection -> collection.size() > 1).collect(Collectors.toList());
        if (!duplicates.isEmpty()) {
            throw new IllegalStateException(FeatureFlagStringUtil.stringFormat("The following duplicate feature flags are found in %s: %s", source, duplicates));
        }
    }

    private void addFlag(String key, String value, String resourceType) {
        Optional<String> existingFlag = this.existingFlags.keySet().stream().filter(k -> k.equalsIgnoreCase(key)).findFirst();
        if (existingFlag.isPresent()) {
            this.add(existingFlag.get(), value, resourceType);
        } else {
            this.add(key, value, resourceType);
        }
    }

    private void add(String key, String value, String resourceType) {
        this.existingFlags.put(key, new FeatureFlagValue(value, resourceType));
    }

    private static class FeatureFlagValue {
        final String value;
        final String resourceType;

        private FeatureFlagValue(String value, String resourceType) {
            this.value = value;
            this.resourceType = resourceType;
        }

        public String toString() {
            return this.value;
        }
    }
}

