/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.views.search;

import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.graylog.plugins.views.search.Search;
import org.graylog.plugins.views.search.db.SearchDbService;
import org.graylog.plugins.views.search.errors.PermissionException;
import org.graylog.plugins.views.search.views.ViewDTO;
import org.graylog.plugins.views.search.views.ViewService;
import org.graylog2.plugin.database.users.User;

public class SearchDomain {
    private final SearchDbService dbService;
    private final ViewService viewService;

    @Inject
    public SearchDomain(SearchDbService dbService, ViewService viewService) {
        this.dbService = dbService;
        this.viewService = viewService;
    }

    public Optional<Search> getForUser(String id, User user, Predicate<ViewDTO> viewReadPermission) {
        Optional<Search> search = this.dbService.get(id);
        search.ifPresent(s -> this.checkPermission(user, viewReadPermission, (Search)s));
        return search;
    }

    private void checkPermission(User user, Predicate<ViewDTO> viewReadPermission, Search s) {
        if (!this.hasReadPermissionFor(user, viewReadPermission, s)) {
            throw new PermissionException("User " + user.getName() + " does not have permission to load search " + s.id());
        }
    }

    public List<Search> getAllForUser(User user, Predicate<ViewDTO> viewReadPermission) {
        return this.dbService.streamAll().filter(s -> this.hasReadPermissionFor(user, viewReadPermission, (Search)s)).collect(Collectors.toList());
    }

    private boolean hasReadPermissionFor(User user, Predicate<ViewDTO> viewReadPermission, Search search) {
        if (this.isOwned(search, user)) {
            return true;
        }
        Collection<ViewDTO> views = this.viewService.forSearch(search.id());
        if (views.isEmpty()) {
            return false;
        }
        return views.stream().anyMatch(viewReadPermission);
    }

    private boolean isOwned(Search search, User user) {
        return search.owner().map(o -> o.equals(user.getName())).orElse(false);
    }
}

