/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.rest.resources.users;

import com.codahale.metrics.annotation.Timed;
import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.validation.Valid;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import javax.ws.rs.BadRequestException;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.ForbiddenException;
import javax.ws.rs.GET;
import javax.ws.rs.InternalServerErrorException;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.apache.commons.lang.StringUtils;
import org.apache.shiro.authz.annotation.RequiresAuthentication;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.apache.shiro.authz.permission.WildcardPermission;
import org.graylog.security.UserContext;
import org.graylog.security.permissions.GRNPermission;
import org.graylog2.audit.jersey.AuditEvent;
import org.graylog2.database.PaginatedList;
import org.graylog2.plugin.database.ValidationException;
import org.graylog2.plugin.database.users.User;
import org.graylog2.rest.models.PaginatedResponse;
import org.graylog2.rest.models.users.requests.ChangePasswordRequest;
import org.graylog2.rest.models.users.requests.ChangeUserRequest;
import org.graylog2.rest.models.users.requests.CreateUserRequest;
import org.graylog2.rest.models.users.requests.PermissionEditRequest;
import org.graylog2.rest.models.users.requests.Startpage;
import org.graylog2.rest.models.users.requests.UpdateUserPreferences;
import org.graylog2.rest.models.users.responses.Token;
import org.graylog2.rest.models.users.responses.TokenList;
import org.graylog2.rest.models.users.responses.TokenSummary;
import org.graylog2.rest.models.users.responses.UserList;
import org.graylog2.rest.models.users.responses.UserSummary;
import org.graylog2.search.SearchQuery;
import org.graylog2.search.SearchQueryField;
import org.graylog2.search.SearchQueryParser;
import org.graylog2.security.AccessToken;
import org.graylog2.security.AccessTokenService;
import org.graylog2.security.MongoDBSessionService;
import org.graylog2.security.MongoDbSession;
import org.graylog2.shared.rest.resources.RestResource;
import org.graylog2.shared.users.Role;
import org.graylog2.shared.users.Roles;
import org.graylog2.shared.users.UserManagementService;
import org.graylog2.users.PaginatedUserService;
import org.graylog2.users.RoleService;
import org.graylog2.users.UserOverviewDTO;
import org.joda.time.DateTimeZone;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RequiresAuthentication
@Path(value="/users")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@Api(value="Users", description="User accounts")
public class UsersResource
extends RestResource {
    private static final Logger LOG = LoggerFactory.getLogger(UsersResource.class);
    private final UserManagementService userManagementService;
    private final PaginatedUserService paginatedUserService;
    private final AccessTokenService accessTokenService;
    private final RoleService roleService;
    private final MongoDBSessionService sessionService;
    private final SearchQueryParser searchQueryParser;
    protected static final ImmutableMap<String, SearchQueryField> SEARCH_FIELD_MAPPING = ImmutableMap.builder().put((Object)"id", (Object)SearchQueryField.create("_id", SearchQueryField.Type.OBJECT_ID)).put((Object)"username", (Object)SearchQueryField.create("username")).put((Object)"full_name", (Object)SearchQueryField.create("full_name")).put((Object)"email", (Object)SearchQueryField.create("email")).build();

    @Inject
    public UsersResource(UserManagementService userManagementService, PaginatedUserService paginatedUserService, AccessTokenService accessTokenService, RoleService roleService, MongoDBSessionService sessionService) {
        this.userManagementService = userManagementService;
        this.accessTokenService = accessTokenService;
        this.roleService = roleService;
        this.sessionService = sessionService;
        this.paginatedUserService = paginatedUserService;
        this.searchQueryParser = new SearchQueryParser("full_name", (Map<String, SearchQueryField>)SEARCH_FIELD_MAPPING);
    }

    @GET
    @Deprecated
    @Path(value="{username}")
    @ApiOperation(value="Get user details", notes="The user's permissions are only included if a user asks for his own account or for users with the necessary permissions to edit permissions.")
    @ApiResponses(value={@ApiResponse(code=404, message="The user could not be found.")})
    public UserSummary get(@ApiParam(name="username", value="The username to return information for.", required=true) @PathParam(value="username") String username, @Context UserContext userContext) {
        if (!this.isPermitted("users:edit", username)) {
            throw new ForbiddenException("Not allowed to view user " + username);
        }
        User user = this.userManagementService.load(username);
        if (user == null) {
            throw new NotFoundException("Couldn't find user " + username);
        }
        return this.returnSummary(userContext, user);
    }

    @GET
    @Path(value="id/{userId}")
    @ApiOperation(value="Get user details by userId", notes="The user's permissions are only included if a user asks for his own account or for users with the necessary permissions to edit permissions.")
    @ApiResponses(value={@ApiResponse(code=404, message="The user could not be found.")})
    public UserSummary getbyId(@ApiParam(name="userId", value="The userId to return information for.", required=true) @PathParam(value="userId") String userId, @Context UserContext userContext) {
        User user = this.loadUserById(userId);
        String username = user.getName();
        if (!this.isPermitted("users:edit", username)) {
            throw new ForbiddenException("Not allowed to view userId " + userId);
        }
        return this.returnSummary(userContext, user);
    }

    private UserSummary returnSummary(UserContext userContext, User user) {
        String requestingUser = userContext.getUser().getId();
        boolean isSelf = requestingUser.equals(user.getId());
        boolean canEditUserPermissions = this.isPermitted("users:permissionsedit", user.getName());
        return this.toUserResponse(user, isSelf || canEditUserPermissions, AllUserSessions.create(this.sessionService));
    }

    @GET
    @Deprecated
    @RequiresPermissions(value={"users:list"})
    @ApiOperation(value="List all users", notes="The permissions assigned to the users are always included.")
    public UserList listUsers() {
        List<User> users = this.userManagementService.loadAll();
        AllUserSessions sessions = AllUserSessions.create(this.sessionService);
        ArrayList resultUsers = Lists.newArrayListWithCapacity((int)(users.size() + 1));
        this.userManagementService.getRootUser().ifPresent(adminUser -> resultUsers.add(this.toUserResponse((User)adminUser, sessions)));
        for (User user : users) {
            resultUsers.add(this.toUserResponse(user, sessions));
        }
        return UserList.create(resultUsers);
    }

    @GET
    @Timed
    @Path(value="/paginated")
    @ApiOperation(value="Get paginated list of users")
    @RequiresPermissions(value={"users:list"})
    @Produces(value={"application/json"})
    public PaginatedResponse<UserOverviewDTO> getPage(@ApiParam(name="page") @QueryParam(value="page") @DefaultValue(value="1") int page, @ApiParam(name="per_page") @QueryParam(value="per_page") @DefaultValue(value="50") int perPage, @ApiParam(name="query") @QueryParam(value="query") @DefaultValue(value="") String query, @ApiParam(name="sort", value="The field to sort the result on", required=true, allowableValues="title,description") @DefaultValue(value="full_name") @QueryParam(value="sort") String sort, @ApiParam(name="order", value="The sort direction", allowableValues="asc, desc") @DefaultValue(value="asc") @QueryParam(value="order") String order) {
        Map<String, String> roleNameMap;
        SearchQuery searchQuery;
        AllUserSessions sessions = AllUserSessions.create(this.sessionService);
        try {
            searchQuery = this.searchQueryParser.parse(query);
        }
        catch (IllegalArgumentException e) {
            throw new BadRequestException("Invalid argument in search query: " + e.getMessage());
        }
        PaginatedList<UserOverviewDTO> result = this.paginatedUserService.findPaginated(searchQuery, page, perPage, sort, order);
        Set<String> allRoleIds = result.stream().flatMap(userDTO -> {
            if (userDTO.roles() != null) {
                return userDTO.roles().stream();
            }
            return Stream.empty();
        }).collect(Collectors.toSet());
        try {
            roleNameMap = this.getRoleNameMap(allRoleIds);
        }
        catch (org.graylog2.database.NotFoundException e) {
            throw new NotFoundException("Couldn't find roles: " + e.getMessage());
        }
        UserOverviewDTO adminUser = this.getAdminUserDTO(sessions);
        List users = result.stream().map(userDTO -> {
            UserOverviewDTO.Builder builder = userDTO.toBuilder().fillSession(sessions.forUser((UserOverviewDTO)userDTO));
            if (userDTO.roles() != null) {
                builder.roles(userDTO.roles().stream().map(roleNameMap::get).collect(Collectors.toSet()));
            }
            return builder.build();
        }).collect(Collectors.toList());
        PaginatedList userOverviewDTOS = new PaginatedList(users, result.pagination().total(), result.pagination().page(), result.pagination().perPage());
        return PaginatedResponse.create("users", userOverviewDTOS, query, Collections.singletonMap("admin_user", adminUser));
    }

    @POST
    @RequiresPermissions(value={"users:create"})
    @ApiOperation(value="Create a new user account.")
    @ApiResponses(value={@ApiResponse(code=400, message="Missing or invalid user details.")})
    @AuditEvent(type="server:user:create")
    public Response create(@ApiParam(name="JSON body", value="Must contain username, full_name, email, password and a list of permissions.", required=true) @Valid @NotNull CreateUserRequest cr) throws ValidationException {
        Startpage startpage;
        Long sessionTimeoutMs;
        if (this.userManagementService.load(cr.username()) != null) {
            String msg = "Cannot create user " + cr.username() + ". Username is already taken.";
            LOG.error(msg);
            throw new BadRequestException(msg);
        }
        if (this.rolesContainAdmin(cr.roles()) && cr.isServiceAccount()) {
            throw new BadRequestException("Cannot assign Admin role to service account");
        }
        User user = this.userManagementService.create();
        user.setName(cr.username());
        user.setPassword(cr.password());
        user.setFirstLastFullNames(cr.firstName(), cr.lastName());
        user.setEmail(cr.email());
        user.setPermissions(cr.permissions());
        this.setUserRoles(cr.roles(), user);
        user.setServiceAccount(cr.isServiceAccount());
        if (cr.timezone() != null) {
            user.setTimeZone(cr.timezone());
        }
        if ((sessionTimeoutMs = cr.sessionTimeoutMs()) != null) {
            user.setSessionTimeoutMs(sessionTimeoutMs);
        }
        if ((startpage = cr.startpage()) != null) {
            user.setStartpage(startpage.type(), startpage.id());
        }
        String id = this.userManagementService.create(user);
        LOG.debug("Saved user {} with id {}", (Object)user.getName(), (Object)id);
        URI userUri = this.getUriBuilderToSelf().path(UsersResource.class).path("{username}").build(new Object[]{user.getName()});
        return Response.created((URI)userUri).build();
    }

    private void setUserRoles(@Nullable List<String> roles, User user) {
        if (roles != null) {
            try {
                Map<String, Role> nameMap = this.roleService.loadAllLowercaseNameMap();
                ArrayList unknownRoles = new ArrayList();
                roles.forEach(roleName -> {
                    if (!nameMap.containsKey(roleName.toLowerCase(Locale.US))) {
                        unknownRoles.add(roleName);
                    }
                });
                if (!unknownRoles.isEmpty()) {
                    throw new BadRequestException(String.format(Locale.ENGLISH, "Invalid role names: %s", StringUtils.join(unknownRoles, (String)", ")));
                }
                Iterable roleIds = Iterables.transform(roles, (Function)Roles.roleNameToIdFunction(nameMap));
                user.setRoleIds(Sets.newHashSet((Iterable)roleIds));
            }
            catch (org.graylog2.database.NotFoundException e) {
                throw new InternalServerErrorException((Throwable)e);
            }
        }
    }

    @PUT
    @Path(value="{userId}")
    @ApiOperation(value="Modify user details.")
    @ApiResponses(value={@ApiResponse(code=400, message="Attempted to modify a read only user account (e.g. built-in or LDAP users)."), @ApiResponse(code=400, message="Missing or invalid user details.")})
    @AuditEvent(type="server:user:update")
    public void changeUser(@ApiParam(name="userId", value="The ID of the user to modify.", required=true) @PathParam(value="userId") String userId, @ApiParam(name="JSON body", value="Updated user information.", required=true) @Valid @NotNull ChangeUserRequest cr) throws ValidationException {
        Long sessionTimeoutMs;
        String timezone;
        boolean permitted;
        User user = this.loadUserById(userId);
        String username = user.getName();
        this.checkPermission("users:edit", username);
        if (user.isReadOnly()) {
            throw new BadRequestException("Cannot modify readonly user " + username);
        }
        if (!user.isExternalUser()) {
            if (cr.email() != null) {
                user.setEmail(cr.email());
            }
            if (cr.firstName() != null && cr.lastName() != null) {
                user.setFirstLastFullNames(cr.firstName(), cr.lastName());
            }
        }
        if ((permitted = this.isPermitted("users:permissionsedit", user.getName())) && cr.permissions() != null) {
            user.setPermissions(this.getEffectiveUserPermissions(user, cr.permissions()));
        }
        if (this.isPermitted("users:rolesedit", user.getName())) {
            this.checkAdminRoleForServiceAccount(cr, user);
            this.setUserRoles(cr.roles(), user);
        }
        if ((timezone = cr.timezone()) == null) {
            user.setTimeZone((String)null);
        } else {
            try {
                if (timezone.isEmpty()) {
                    user.setTimeZone((String)null);
                } else {
                    DateTimeZone tz = DateTimeZone.forID((String)timezone);
                    user.setTimeZone(tz);
                }
            }
            catch (IllegalArgumentException e) {
                LOG.error("Invalid timezone '{}', ignoring it for user {}.", (Object)timezone, (Object)username);
            }
        }
        Startpage startpage = cr.startpage();
        if (startpage != null) {
            user.setStartpage(startpage.type(), startpage.id());
        }
        if (this.isPermitted("*") && (sessionTimeoutMs = cr.sessionTimeoutMs()) != null && sessionTimeoutMs != 0L) {
            user.setSessionTimeoutMs(sessionTimeoutMs);
        }
        if (cr.isServiceAccount() != null) {
            user.setServiceAccount(cr.isServiceAccount());
        }
        this.userManagementService.update(user);
    }

    private boolean rolesContainAdmin(List<String> roles) {
        return roles != null && roles.stream().anyMatch("Admin"::equalsIgnoreCase);
    }

    private void checkAdminRoleForServiceAccount(ChangeUserRequest cr, User user) {
        if (user.isServiceAccount() && this.rolesContainAdmin(cr.roles())) {
            throw new BadRequestException("Cannot assign Admin role to service account");
        }
        if (cr.isServiceAccount() != null && cr.isServiceAccount().booleanValue() && user.getRoleIds().contains(this.roleService.getAdminRoleObjectId())) {
            throw new BadRequestException("Cannot make Admin into service account");
        }
    }

    @DELETE
    @Path(value="{username}")
    @RequiresPermissions(value={"users:edit"})
    @ApiOperation(value="Removes a user account.")
    @ApiResponses(value={@ApiResponse(code=400, message="When attempting to remove a read only user (e.g. built-in or LDAP user).")})
    @AuditEvent(type="server:user:delete")
    public void deleteUser(@ApiParam(name="username", value="The name of the user to delete.", required=true) @PathParam(value="username") String username) {
        if (this.userManagementService.delete(username) == 0) {
            throw new NotFoundException("Couldn't find user " + username);
        }
    }

    @DELETE
    @Path(value="id/{userId}")
    @RequiresPermissions(value={"users:edit"})
    @ApiOperation(value="Removes a user account.")
    @ApiResponses(value={@ApiResponse(code=400, message="When attempting to remove a read only user (e.g. built-in or LDAP user).")})
    @AuditEvent(type="server:user:delete")
    public void deleteUserById(@ApiParam(name="userId", value="The id of the user to delete.", required=true) @PathParam(value="userId") String userId) {
        if (this.userManagementService.deleteById(userId) == 0) {
            throw new NotFoundException("Couldn't find user " + userId);
        }
    }

    @PUT
    @Path(value="{username}/permissions")
    @RequiresPermissions(value={"users:permissionsedit"})
    @ApiOperation(value="Update a user's permission set.")
    @ApiResponses(value={@ApiResponse(code=400, message="Missing or invalid permission data.")})
    @AuditEvent(type="server:user_permissions:update")
    public void editPermissions(@ApiParam(name="username", value="The name of the user to modify.", required=true) @PathParam(value="username") String username, @ApiParam(name="JSON body", value="The list of permissions to assign to the user.", required=true) @Valid @NotNull PermissionEditRequest permissionRequest) throws ValidationException {
        User user = this.userManagementService.load(username);
        if (user == null) {
            throw new NotFoundException("Couldn't find user " + username);
        }
        user.setPermissions(this.getEffectiveUserPermissions(user, permissionRequest.permissions()));
        this.userManagementService.save(user);
    }

    @PUT
    @Path(value="{username}/preferences")
    @ApiOperation(value="Update a user's preferences set.")
    @ApiResponses(value={@ApiResponse(code=400, message="Missing or invalid permission data.")})
    @AuditEvent(type="server:user_preferences:update")
    public void savePreferences(@ApiParam(name="username", value="The name of the user to modify.", required=true) @PathParam(value="username") String username, @ApiParam(name="JSON body", value="The map of preferences to assign to the user.", required=true) UpdateUserPreferences preferencesRequest) throws ValidationException {
        User user = this.userManagementService.load(username);
        this.checkPermission("users:edit", username);
        if (user == null) {
            throw new NotFoundException("Couldn't find user " + username);
        }
        user.setPreferences(preferencesRequest.preferences());
        this.userManagementService.save(user);
    }

    @DELETE
    @Path(value="{username}/permissions")
    @RequiresPermissions(value={"users:permissionsedit"})
    @ApiOperation(value="Revoke all permissions for a user without deleting the account.")
    @ApiResponses(value={@ApiResponse(code=500, message="When saving the user failed.")})
    @AuditEvent(type="server:user_permissions:delete")
    public void deletePermissions(@ApiParam(name="username", value="The name of the user to modify.", required=true) @PathParam(value="username") String username) throws ValidationException {
        User user = this.userManagementService.load(username);
        if (user == null) {
            throw new NotFoundException("Couldn't find user " + username);
        }
        user.setPermissions(Collections.emptyList());
        this.userManagementService.save(user);
    }

    @PUT
    @Path(value="{userId}/password")
    @ApiOperation(value="Update the password for a user.")
    @ApiResponses(value={@ApiResponse(code=204, message="The password was successfully updated. Subsequent requests must be made with the new password."), @ApiResponse(code=400, message="The new password is missing, or the old password is missing or incorrect."), @ApiResponse(code=403, message="The requesting user has insufficient privileges to update the password for the given user."), @ApiResponse(code=404, message="User does not exist.")})
    @AuditEvent(type="server:user_password:update")
    public void changePassword(@ApiParam(name="userId", value="The id of the user whose password to change.", required=true) @PathParam(value="userId") String userId, @ApiParam(name="JSON body", value="The old and new passwords.", required=true) @Valid ChangePasswordRequest cr) throws ValidationException {
        User user = this.loadUserById(userId);
        String username = user.getName();
        if (!this.getSubject().isPermitted("users:passwordchange:" + username)) {
            throw new ForbiddenException("Not allowed to change password for user " + username);
        }
        if (user.isExternalUser()) {
            String msg = "Cannot change password for external user.";
            LOG.error("Cannot change password for external user.");
            throw new ForbiddenException("Cannot change password for external user.");
        }
        boolean checkOldPassword = true;
        if (this.getSubject().isPermitted("users:passwordchange:*")) {
            if (username.equals(this.getSubject().getPrincipal())) {
                LOG.debug("User {} is allowed to change the password of any user, but attempts to change own password. Must supply the old password.", this.getSubject().getPrincipal());
                checkOldPassword = true;
            } else {
                LOG.debug("User {} is allowed to change the password for any user, including {}, ignoring old password", this.getSubject().getPrincipal(), (Object)username);
                checkOldPassword = false;
            }
        }
        boolean changeAllowed = false;
        if (checkOldPassword) {
            if (this.userManagementService.isUserPassword(user, cr.oldPassword())) {
                changeAllowed = true;
            }
        } else {
            changeAllowed = true;
        }
        if (changeAllowed) {
            if (checkOldPassword) {
                this.userManagementService.changePassword(user, cr.oldPassword(), cr.password());
            } else {
                this.userManagementService.changePassword(user, cr.password());
            }
        } else {
            throw new BadRequestException("Old password is missing or incorrect.");
        }
    }

    @PUT
    @Path(value="{userId}/status/{newStatus}")
    @Consumes(value={"*/*"})
    @ApiOperation(value="Update the account status for a user")
    @AuditEvent(type="server:user:update")
    public Response updateAccountStatus(@ApiParam(name="userId", value="The id of the user whose status to change.", required=true) @PathParam(value="userId") @NotBlank String userId, @ApiParam(name="newStatus", value="The account status to be set", required=true, defaultValue="enabled", allowableValues="enabled,disabled,deleted") @PathParam(value="newStatus") @NotBlank String newStatusString, @Context UserContext userContext) throws ValidationException {
        if (userId.equalsIgnoreCase(userContext.getUserId())) {
            throw new BadRequestException("Users are not allowed to set their own status");
        }
        User.AccountStatus newStatus = User.AccountStatus.valueOf(newStatusString.toUpperCase(Locale.US));
        User user = this.loadUserById(userId);
        this.checkPermission("users:edit", user.getName());
        User.AccountStatus oldStatus = user.getAccountStatus();
        if (oldStatus.equals((Object)newStatus)) {
            return Response.notModified().build();
        }
        this.userManagementService.setUserStatus(user, newStatus);
        return Response.ok().build();
    }

    @GET
    @Path(value="{userId}/tokens")
    @ApiOperation(value="Retrieves the list of access tokens for a user")
    public TokenList listTokens(@ApiParam(name="userId", required=true) @PathParam(value="userId") String userId) {
        User user = this.loadUserById(userId);
        String username = user.getName();
        if (!this.isPermitted("users:tokenlist", username)) {
            throw new ForbiddenException("Not allowed to list tokens for user " + username);
        }
        ImmutableList.Builder tokenList = ImmutableList.builder();
        for (AccessToken token : this.accessTokenService.loadAll(user.getName())) {
            tokenList.add((Object)TokenSummary.create(token.getId(), token.getName(), token.getLastAccess()));
        }
        return TokenList.create((List<TokenSummary>)tokenList.build());
    }

    @POST
    @Path(value="{userId}/tokens/{name}")
    @ApiOperation(value="Generates a new access token for a user")
    @AuditEvent(type="server:user_access_token:create")
    public Token generateNewToken(@ApiParam(name="userId", required=true) @PathParam(value="userId") String userId, @ApiParam(name="name", value="Descriptive name for this token (e.g. 'cronjob') ", required=true) @PathParam(value="name") String name, @ApiParam(name="JSON Body", value="Placeholder because POST requests should have a body. Set to '{}', the content will be ignored.", defaultValue="{}") String body) {
        User user = this.loadUserById(userId);
        String username = user.getName();
        if (!this.isPermitted("users:tokencreate", username)) {
            throw new ForbiddenException("Not allowed to create tokens for user " + username);
        }
        AccessToken accessToken = this.accessTokenService.create(user.getName(), name);
        return Token.create(accessToken.getId(), accessToken.getName(), accessToken.getToken(), accessToken.getLastAccess());
    }

    @DELETE
    @Path(value="{userId}/tokens/{idOrToken}")
    @ApiOperation(value="Removes a token for a user")
    @AuditEvent(type="server:user_access_token:delete")
    public void revokeToken(@ApiParam(name="userId", required=true) @PathParam(value="userId") String userId, @ApiParam(name="idOrToken", required=true) @PathParam(value="idOrToken") String idOrToken) {
        User user = this.loadUserById(userId);
        String username = user.getName();
        if (!this.isPermitted("users:tokenremove", username)) {
            throw new ForbiddenException("Not allowed to remove tokens for user " + username);
        }
        AccessToken accessToken = Optional.ofNullable(this.accessTokenService.loadById(idOrToken)).orElse(this.accessTokenService.load(idOrToken));
        if (accessToken == null) {
            throw new NotFoundException("Couldn't find access token for user " + username);
        }
        this.accessTokenService.destroy(accessToken);
    }

    private User loadUserById(String userId) {
        User user = this.userManagementService.loadById(userId);
        if (user == null) {
            throw new NotFoundException("Couldn't find user with ID <" + userId + ">");
        }
        return user;
    }

    private UserSummary toUserResponse(User user, AllUserSessions sessions) {
        return this.toUserResponse(user, true, sessions);
    }

    private UserSummary toUserResponse(User user, boolean includePermissions, AllUserSessions sessions) {
        Object grnPermissions;
        Object wildcardPermissions;
        Set<String> roleIds = user.getRoleIds();
        Set<Object> roleNames = Collections.emptySet();
        if (!roleIds.isEmpty() && (roleNames = this.userManagementService.getRoleNames(user)).isEmpty()) {
            LOG.error("Unable to load role names for role IDs {} for user {}", roleIds, (Object)user);
        }
        boolean sessionActive = false;
        Date lastActivity = null;
        String clientAddress = null;
        Optional<MongoDbSession> mongoDbSession = sessions.forUser(user);
        if (mongoDbSession.isPresent()) {
            MongoDbSession session = mongoDbSession.get();
            sessionActive = true;
            lastActivity = session.getLastAccessTime();
            clientAddress = session.getHost();
        }
        if (includePermissions) {
            wildcardPermissions = this.userManagementService.getWildcardPermissionsForUser(user);
            grnPermissions = this.userManagementService.getGRNPermissionsForUser(user);
        } else {
            wildcardPermissions = ImmutableList.of();
            grnPermissions = ImmutableList.of();
        }
        return UserSummary.create(user.getId(), user.getName(), user.getEmail(), user.getFirstName().orElse(null), user.getLastName().orElse(null), user.getFullName(), (List<WildcardPermission>)wildcardPermissions, (List<GRNPermission>)grnPermissions, user.getPreferences(), user.getTimeZone() == null ? null : user.getTimeZone().getID(), user.getSessionTimeoutMs(), user.isReadOnly(), user.isExternalUser(), user.getStartpage(), roleNames, sessionActive, lastActivity, clientAddress, user.getAccountStatus(), user.isServiceAccount());
    }

    private List<String> getEffectiveUserPermissions(User user, List<String> permissions) {
        ArrayList effectivePermissions = Lists.newArrayList(permissions);
        effectivePermissions.removeAll(this.userManagementService.getUserPermissionsFromRoles(user));
        return effectivePermissions;
    }

    private Map<String, String> getRoleNameMap(Set<String> roleIds) throws org.graylog2.database.NotFoundException {
        Map<String, Role> roleMap = this.roleService.findIdMap(roleIds);
        HashMap<String, String> result = new HashMap<String, String>(roleMap.size());
        roleMap.forEach((key, value) -> result.put((String)key, value.getName()));
        return result;
    }

    private UserOverviewDTO getAdminUserDTO(AllUserSessions sessions) {
        Optional<User> optionalAdmin = this.userManagementService.getRootUser();
        if (!optionalAdmin.isPresent()) {
            return null;
        }
        User admin = optionalAdmin.get();
        Set<String> adminRoles = this.userManagementService.getRoleNames(admin);
        Optional<MongoDbSession> lastSession = sessions.forUser(admin);
        return UserOverviewDTO.builder().username(admin.getName()).fullName(admin.getFullName()).email(admin.getEmail()).externalUser(admin.isExternalUser()).readOnly(admin.isReadOnly()).id(admin.getId()).fillSession(lastSession).roles(adminRoles).build();
    }

    private static class AllUserSessions {
        private final Map<String, Optional<MongoDbSession>> sessions;

        public static AllUserSessions create(MongoDBSessionService sessionService) {
            return new AllUserSessions(sessionService.loadAll());
        }

        private AllUserSessions(Collection<MongoDbSession> sessions) {
            this.sessions = this.getLastSessionForUser(sessions);
        }

        public Optional<MongoDbSession> forUser(User user) {
            return this.sessions.getOrDefault(user.getId(), Optional.empty());
        }

        public Optional<MongoDbSession> forUser(UserOverviewDTO user) {
            return this.sessions.getOrDefault(user.id(), Optional.empty());
        }

        private Map<String, Optional<MongoDbSession>> getLastSessionForUser(Collection<MongoDbSession> sessions) {
            return sessions.stream().filter(s -> s.getUserIdAttribute().isPresent()).collect(Collectors.groupingBy(s -> s.getUserIdAttribute().get(), Collectors.maxBy(Comparator.comparing(MongoDbSession::getLastAccessTime))));
        }
    }
}

