/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.map.geoip;

import com.codahale.metrics.Timer;
import com.google.inject.assistedinject.Assisted;
import com.maxmind.geoip2.exception.AddressNotFoundException;
import com.maxmind.geoip2.exception.GeoIp2Exception;
import com.maxmind.geoip2.model.CityResponse;
import com.maxmind.geoip2.record.City;
import com.maxmind.geoip2.record.Country;
import com.maxmind.geoip2.record.Location;
import java.io.IOException;
import java.net.InetAddress;
import java.util.Optional;
import javax.inject.Inject;
import org.graylog.plugins.map.geoip.GeoLocationInformation;
import org.graylog.plugins.map.geoip.MaxMindIpResolver;

public class MaxMindIpLocationResolver
extends MaxMindIpResolver<GeoLocationInformation> {
    @Inject
    public MaxMindIpLocationResolver(@Assisted Timer resolveTime, @Assisted String configPath, @Assisted boolean enabled) {
        super(resolveTime, configPath, enabled);
    }

    @Override
    public Optional<GeoLocationInformation> doGetGeoIpData(InetAddress address) {
        GeoLocationInformation info;
        block14: {
            try (Timer.Context ignored = this.resolveTime.time();){
                CityResponse response = this.databaseReader.city(address);
                Location location = response.getLocation();
                Country country = response.getCountry();
                City city = response.getCity();
                info = GeoLocationInformation.create(location.getLatitude(), location.getLongitude(), country.getGeoNameId() == null ? "N/A" : country.getIsoCode(), country.getGeoNameId() == null ? "N/A" : country.getName(), city.getGeoNameId() == null ? "N/A" : city.getName(), "N/A", "N/A");
            }
            catch (GeoIp2Exception | IOException | UnsupportedOperationException e) {
                info = null;
                if (e instanceof AddressNotFoundException) break block14;
                LOG.debug("Could not get location from IP {}", (Object)address.getHostAddress(), (Object)e);
                this.lastError = e.getMessage();
            }
        }
        return Optional.ofNullable(info);
    }
}

