/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.pipelineprocessor.rest;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.validation.constraints.NotNull;
import javax.ws.rs.BadRequestException;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.apache.shiro.authz.annotation.RequiresAuthentication;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.graylog.plugins.pipelineprocessor.ast.Pipeline;
import org.graylog.plugins.pipelineprocessor.db.PaginatedPipelineService;
import org.graylog.plugins.pipelineprocessor.db.PipelineDao;
import org.graylog.plugins.pipelineprocessor.db.PipelineService;
import org.graylog.plugins.pipelineprocessor.parser.ParseException;
import org.graylog.plugins.pipelineprocessor.parser.PipelineRuleParser;
import org.graylog.plugins.pipelineprocessor.rest.PipelineSource;
import org.graylog.plugins.pipelineprocessor.rest.StageSource;
import org.graylog2.audit.jersey.AuditEvent;
import org.graylog2.audit.jersey.NoAuditEvent;
import org.graylog2.database.NotFoundException;
import org.graylog2.database.PaginatedList;
import org.graylog2.plugin.rest.PluginRestResource;
import org.graylog2.rest.models.PaginatedResponse;
import org.graylog2.search.SearchQuery;
import org.graylog2.search.SearchQueryField;
import org.graylog2.search.SearchQueryParser;
import org.graylog2.shared.rest.resources.RestResource;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Api(value="Pipelines/Pipelines", description="Pipelines for the pipeline message processor")
@Path(value="/system/pipelines/pipeline")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@RequiresAuthentication
public class PipelineResource
extends RestResource
implements PluginRestResource {
    private static final Logger log = LoggerFactory.getLogger(PipelineResource.class);
    private static final ImmutableMap<String, SearchQueryField> SEARCH_FIELD_MAPPING = ImmutableMap.builder().put((Object)"id", (Object)SearchQueryField.create("_id", SearchQueryField.Type.OBJECT_ID)).put((Object)"title", (Object)SearchQueryField.create("title")).put((Object)"description", (Object)SearchQueryField.create("description")).build();
    private final SearchQueryParser searchQueryParser;
    private final PaginatedPipelineService paginatedPipelineService;
    private final PipelineService pipelineService;
    private final PipelineRuleParser pipelineRuleParser;

    @Inject
    public PipelineResource(PipelineService pipelineService, PaginatedPipelineService paginatedPipelineService, PipelineRuleParser pipelineRuleParser) {
        this.pipelineService = pipelineService;
        this.pipelineRuleParser = pipelineRuleParser;
        this.paginatedPipelineService = paginatedPipelineService;
        this.searchQueryParser = new SearchQueryParser("title", (Map<String, SearchQueryField>)SEARCH_FIELD_MAPPING);
    }

    @ApiOperation(value="Create a processing pipeline from source")
    @POST
    @RequiresPermissions(value={"pipeline:create"})
    @AuditEvent(type="pipeline_processor:pipeline:create")
    public PipelineSource createFromParser(@ApiParam(name="pipeline", required=true) @NotNull PipelineSource pipelineSource) throws ParseException {
        Pipeline pipeline;
        try {
            pipeline = this.pipelineRuleParser.parsePipeline(pipelineSource.id(), pipelineSource.source());
        }
        catch (ParseException e) {
            throw new BadRequestException(Response.status((Response.Status)Response.Status.BAD_REQUEST).entity(e.getErrors()).build());
        }
        DateTime now = DateTime.now((DateTimeZone)DateTimeZone.UTC);
        PipelineDao pipelineDao = PipelineDao.builder().title(pipeline.name()).description(pipelineSource.description()).source(pipelineSource.source()).createdAt(now).modifiedAt(now).build();
        PipelineDao save = this.pipelineService.save(pipelineDao);
        log.debug("Created new pipeline {}", (Object)save);
        return PipelineSource.fromDao(this.pipelineRuleParser, save);
    }

    @ApiOperation(value="Parse a processing pipeline without saving it")
    @POST
    @Path(value="/parse")
    @NoAuditEvent(value="only used to parse a pipeline, no changes made in the system")
    public PipelineSource parse(@ApiParam(name="pipeline", required=true) @NotNull PipelineSource pipelineSource) throws ParseException {
        Pipeline pipeline;
        try {
            pipeline = this.pipelineRuleParser.parsePipeline(pipelineSource.id(), pipelineSource.source());
        }
        catch (ParseException e) {
            throw new BadRequestException(Response.status((Response.Status)Response.Status.BAD_REQUEST).entity(e.getErrors()).build());
        }
        DateTime now = DateTime.now((DateTimeZone)DateTimeZone.UTC);
        return PipelineSource.builder().title(pipeline.name()).description(pipelineSource.description()).source(pipelineSource.source()).stages(pipeline.stages().stream().map(stage -> StageSource.create(stage.stage(), stage.match(), stage.ruleReferences())).collect(Collectors.toList())).createdAt(now).modifiedAt(now).build();
    }

    @ApiOperation(value="Get all processing pipelines")
    @GET
    public Collection<PipelineSource> getAll() {
        Collection<PipelineDao> daos = this.pipelineService.loadAll();
        ArrayList results = Lists.newArrayList();
        for (PipelineDao dao : daos) {
            if (!this.isPermitted("pipeline:read", dao.id())) continue;
            results.add(PipelineSource.fromDao(this.pipelineRuleParser, dao));
        }
        return results;
    }

    @GET
    @Path(value="/paginated")
    @ApiOperation(value="Get a paginated list of pipelines")
    @Produces(value={"application/json"})
    public PaginatedResponse<PipelineSource> getPage(@ApiParam(name="page") @QueryParam(value="page") @DefaultValue(value="1") int page, @ApiParam(name="per_page") @QueryParam(value="per_page") @DefaultValue(value="50") int perPage, @ApiParam(name="query") @QueryParam(value="query") @DefaultValue(value="") String query, @ApiParam(name="sort", value="The field to sort the result on", required=true, allowableValues="title,description,id") @DefaultValue(value="title") @QueryParam(value="sort") String sort, @ApiParam(name="order", value="The sort direction", allowableValues="asc, desc") @DefaultValue(value="asc") @QueryParam(value="order") String order) {
        SearchQuery searchQuery;
        try {
            searchQuery = this.searchQueryParser.parse(query);
        }
        catch (IllegalArgumentException e) {
            throw new BadRequestException("Invalid argument in search query: " + e.getMessage());
        }
        Predicate<PipelineDao> filter = dao -> this.isPermitted("pipeline:read", dao.id());
        PaginatedList<PipelineDao> result = this.paginatedPipelineService.findPaginated(searchQuery, filter, page, perPage, sort, order);
        List pipelineList = result.stream().map(dao -> PipelineSource.fromDao(this.pipelineRuleParser, dao)).collect(Collectors.toList());
        PaginatedList pipelines = new PaginatedList(pipelineList, result.pagination().total(), result.pagination().page(), result.pagination().perPage());
        return PaginatedResponse.create("pipelines", pipelines);
    }

    @ApiOperation(value="Get a processing pipeline", notes="It can take up to a second until the change is applied")
    @Path(value="/{id}")
    @GET
    public PipelineSource get(@ApiParam(name="id") @PathParam(value="id") String id) throws NotFoundException {
        this.checkPermission("pipeline:read", id);
        PipelineDao dao = this.pipelineService.load(id);
        return PipelineSource.fromDao(this.pipelineRuleParser, dao);
    }

    @ApiOperation(value="Modify a processing pipeline", notes="It can take up to a second until the change is applied")
    @Path(value="/{id}")
    @PUT
    @AuditEvent(type="pipeline_processor:pipeline:update")
    public PipelineSource update(@ApiParam(name="id") @PathParam(value="id") String id, @ApiParam(name="pipeline", required=true) @NotNull PipelineSource update) throws NotFoundException {
        Pipeline pipeline;
        this.checkPermission("pipeline:edit", id);
        PipelineDao dao = this.pipelineService.load(id);
        try {
            pipeline = this.pipelineRuleParser.parsePipeline(update.id(), update.source());
        }
        catch (ParseException e) {
            throw new BadRequestException(Response.status((Response.Status)Response.Status.BAD_REQUEST).entity(e.getErrors()).build());
        }
        PipelineDao toSave = dao.toBuilder().title(pipeline.name()).description(update.description()).source(update.source()).modifiedAt(DateTime.now((DateTimeZone)DateTimeZone.UTC)).build();
        PipelineDao savedPipeline = this.pipelineService.save(toSave);
        return PipelineSource.fromDao(this.pipelineRuleParser, savedPipeline);
    }

    @ApiOperation(value="Delete a processing pipeline", notes="It can take up to a second until the change is applied")
    @Path(value="/{id}")
    @DELETE
    @AuditEvent(type="pipeline_processor:pipeline:delete")
    public void delete(@ApiParam(name="id") @PathParam(value="id") String id) throws NotFoundException {
        this.checkPermission("pipeline:delete", id);
        this.pipelineService.load(id);
        this.pipelineService.delete(id);
    }
}

