/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.views.search.rest;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.eventbus.EventBus;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.io.UnsupportedEncodingException;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.inject.Inject;
import javax.validation.Valid;
import javax.ws.rs.BadRequestException;
import javax.ws.rs.GET;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import org.apache.shiro.authz.annotation.RequiresAuthentication;
import org.glassfish.jersey.server.ChunkedOutput;
import org.graylog.plugins.views.search.Search;
import org.graylog.plugins.views.search.SearchDomain;
import org.graylog.plugins.views.search.SearchExecutionGuard;
import org.graylog.plugins.views.search.export.AuditContext;
import org.graylog.plugins.views.search.export.AuditingMessagesExporter;
import org.graylog.plugins.views.search.export.ChunkedRunner;
import org.graylog.plugins.views.search.export.CommandFactory;
import org.graylog.plugins.views.search.export.ExportJob;
import org.graylog.plugins.views.search.export.ExportJobService;
import org.graylog.plugins.views.search.export.ExportMessagesCommand;
import org.graylog.plugins.views.search.export.MessagesExporter;
import org.graylog.plugins.views.search.export.MessagesRequest;
import org.graylog.plugins.views.search.export.MessagesRequestExportJob;
import org.graylog.plugins.views.search.export.ResultFormat;
import org.graylog.plugins.views.search.export.SearchExportJob;
import org.graylog.plugins.views.search.export.SearchTypeExportJob;
import org.graylog.plugins.views.search.export.SimpleMessageChunk;
import org.graylog.plugins.views.search.permissions.SearchUser;
import org.graylog.plugins.views.search.rest.ExecutionState;
import org.graylog.plugins.views.search.rest.PermittedStreams;
import org.graylog.plugins.views.search.validation.QueryValidationService;
import org.graylog.plugins.views.search.validation.ValidationMessage;
import org.graylog.plugins.views.search.validation.ValidationRequest;
import org.graylog.plugins.views.search.validation.ValidationResponse;
import org.graylog.plugins.views.search.validation.ValidationStatus;
import org.graylog2.audit.jersey.NoAuditEvent;
import org.graylog2.plugin.rest.PluginRestResource;
import org.graylog2.shared.rest.resources.RestResource;
import org.joda.time.DateTimeZone;

@Api(value="Search/Messages", description="Simple search returning (matching) messages only, as CSV.")
@Path(value="/views/search/messages")
@RequiresAuthentication
public class MessagesResource
extends RestResource
implements PluginRestResource {
    private static final DateTimeZone FALLBACK_TIME_ZONE = DateTimeZone.UTC;
    private final CommandFactory commandFactory;
    private final SearchDomain searchDomain;
    private final SearchExecutionGuard executionGuard;
    private final PermittedStreams permittedStreams;
    private final ObjectMapper objectMapper;
    private final ExportJobService exportJobService;
    private final QueryValidationService queryValidationService;
    Function<Consumer<Consumer<SimpleMessageChunk>>, ChunkedOutput<SimpleMessageChunk>> asyncRunner = ChunkedRunner::runAsync;
    Function<AuditContext, MessagesExporter> messagesExporterFactory;

    @Inject
    public MessagesResource(MessagesExporter exporter, CommandFactory commandFactory, SearchDomain searchDomain, SearchExecutionGuard executionGuard, PermittedStreams permittedStreams, ObjectMapper objectMapper, EventBus eventBus, ExportJobService exportJobService, QueryValidationService queryValidationService) {
        this.commandFactory = commandFactory;
        this.searchDomain = searchDomain;
        this.executionGuard = executionGuard;
        this.permittedStreams = permittedStreams;
        this.objectMapper = objectMapper;
        this.exportJobService = exportJobService;
        this.queryValidationService = queryValidationService;
        this.messagesExporterFactory = context -> new AuditingMessagesExporter((AuditContext)context, eventBus, exporter);
    }

    @ApiOperation(value="Export messages as CSV", notes="Use this endpoint, if you want to configure export parameters freely instead of relying on an existing Search")
    @POST
    @Produces(value={"text/csv"})
    @NoAuditEvent(value="Has custom audit events")
    public ChunkedOutput<SimpleMessageChunk> retrieve(@ApiParam @Valid MessagesRequest rawrequest, @Context SearchUser searchUser) {
        MessagesRequest request = this.fillInIfNecessary(rawrequest, searchUser);
        ValidationRequest.Builder validationReq = ValidationRequest.builder();
        Optional.ofNullable(rawrequest.queryString()).ifPresent(validationReq::query);
        Optional.ofNullable(rawrequest.timeRange()).ifPresent(validationReq::timerange);
        Optional.ofNullable(rawrequest.streams()).ifPresent(validationReq::streams);
        ValidationResponse validationResponse = this.queryValidationService.validate(validationReq.build());
        if (validationResponse.status().equals((Object)ValidationStatus.ERROR)) {
            validationResponse.explanations().stream().findFirst().map(ValidationMessage::errorMessage).ifPresent(message -> {
                throw new BadRequestException("Request validation failed: " + message);
            });
        }
        this.executionGuard.checkUserIsPermittedToSeeStreams(request.streams(), searchUser::canReadStream);
        ExportMessagesCommand command = this.commandFactory.buildFromRequest(request);
        return this.asyncRunner.apply(chunkConsumer -> this.exporter().export(command, (Consumer<SimpleMessageChunk>)chunkConsumer));
    }

    private MessagesRequest fillInIfNecessary(MessagesRequest requestFromClient, SearchUser searchUser) {
        MessagesRequest request;
        MessagesRequest messagesRequest = request = requestFromClient != null ? requestFromClient : MessagesRequest.withDefaults();
        if (request.streams().isEmpty()) {
            request = request.withStreams((Set<String>)searchUser.streams().loadAll());
        }
        if (!request.timeZone().isPresent()) {
            request = request.withTimeZone(searchUser.timeZone().orElse(FALLBACK_TIME_ZONE));
        }
        return request;
    }

    private ResultFormat fillInIfNecessary(ResultFormat resultFormat, SearchUser searchUser) {
        return resultFormat.timeZone().isPresent() ? resultFormat : resultFormat.withTimeZone(searchUser.timeZone().orElse(FALLBACK_TIME_ZONE));
    }

    @ApiOperation(value="Export a search result as CSV")
    @POST
    @Path(value="{searchId}")
    @Produces(value={"text/csv"})
    @NoAuditEvent(value="Has custom audit events")
    public ChunkedOutput<SimpleMessageChunk> retrieveForSearch(@ApiParam(value="ID of an existing Search", name="searchId") @PathParam(value="searchId") String searchId, @ApiParam(value="Optional overrides") @Valid ResultFormat formatFromClient, @Context SearchUser searchUser) {
        ResultFormat format = this.fillInIfNecessary(this.emptyIfNull(formatFromClient), searchUser);
        Search search = this.loadSearch(searchId, format.executionState(), searchUser);
        ExportMessagesCommand command = this.commandFactory.buildWithSearchOnly(search, format);
        return this.asyncRunner.apply(chunkConsumer -> this.exporter(searchId).export(command, (Consumer<SimpleMessageChunk>)chunkConsumer));
    }

    @ApiOperation(value="Export a message table as CSV")
    @POST
    @Path(value="{searchId}/{searchTypeId}")
    @NoAuditEvent(value="Has custom audit events")
    public ChunkedOutput<SimpleMessageChunk> retrieveForSearchType(@ApiParam(value="ID of an existing Search", name="searchId") @PathParam(value="searchId") String searchId, @ApiParam(value="ID of a Message Table contained in the Search", name="searchTypeId") @PathParam(value="searchTypeId") String searchTypeId, @ApiParam(value="Optional overrides") @Valid ResultFormat formatFromClient, @Context SearchUser searchUser) {
        ResultFormat format = this.fillInIfNecessary(this.emptyIfNull(formatFromClient), searchUser);
        Search search = this.loadSearch(searchId, format.executionState(), searchUser);
        ExportMessagesCommand command = this.commandFactory.buildWithMessageList(search, searchTypeId, format);
        return this.asyncRunner.apply(chunkConsumer -> this.exporter(searchId, searchTypeId).export(command, (Consumer<SimpleMessageChunk>)chunkConsumer));
    }

    @ApiOperation(value="Retrieve results for export job")
    @GET
    @Path(value="job/{exportJobId}/{filename:.*}")
    public ChunkedOutput<SimpleMessageChunk> retrieveForExportJob(@ApiParam(value="ID of an existing export job", name="exportJobId") @PathParam(value="exportJobId") String exportJobId, @Context SearchUser searchUser) throws UnsupportedEncodingException {
        ExportJob exportJob = this.exportJobService.get(exportJobId).orElseThrow(() -> new NotFoundException("Unable to find export job with id <" + exportJobId + ">!"));
        return this.outputFor(exportJob, searchUser);
    }

    private ChunkedOutput<SimpleMessageChunk> outputFor(ExportJob exportJob, SearchUser searchUser) {
        if (exportJob instanceof MessagesRequestExportJob) {
            MessagesRequest messagesRequest = ((MessagesRequestExportJob)exportJob).messagesRequest();
            return this.retrieve(messagesRequest, searchUser);
        }
        if (exportJob instanceof SearchExportJob) {
            SearchExportJob searchExportJob = (SearchExportJob)exportJob;
            return this.retrieveForSearch(searchExportJob.searchId(), searchExportJob.resultFormat(), searchUser);
        }
        if (exportJob instanceof SearchTypeExportJob) {
            SearchTypeExportJob searchTypeExportJob = (SearchTypeExportJob)exportJob;
            return this.retrieveForSearchType(searchTypeExportJob.searchId(), searchTypeExportJob.searchTypeId(), searchTypeExportJob.resultFormat(), searchUser);
        }
        throw new IllegalStateException("Invalid type of export job: " + exportJob.getClass());
    }

    private MessagesExporter exporter() {
        return this.exporter(null, null);
    }

    private MessagesExporter exporter(String searchId) {
        return this.exporter(searchId, null);
    }

    private MessagesExporter exporter(String searchId, String searchTypeId) {
        return this.messagesExporterFactory.apply(new AuditContext(this.userName(), searchId, searchTypeId));
    }

    private String userName() {
        return Objects.requireNonNull(this.getCurrentUser()).getName();
    }

    private ResultFormat emptyIfNull(ResultFormat format) {
        return format == null ? ResultFormat.empty() : format;
    }

    private Search loadSearch(String searchId, ExecutionState executionState, SearchUser searchUser) {
        Search search = this.searchDomain.getForUser(searchId, searchUser).orElseThrow(() -> new NotFoundException("Search with id " + searchId + " does not exist"));
        search = search.addStreamsToQueriesWithoutStreams(() -> searchUser.streams().loadAll());
        search = search.applyExecutionState(this.objectMapper, executionState);
        this.executionGuard.check(search, searchUser::canReadStream);
        return search;
    }
}

