/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.views.search.rest;

import com.google.common.collect.ImmutableMap;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.Locale;
import java.util.Map;
import javax.inject.Inject;
import javax.ws.rs.BadRequestException;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import org.apache.shiro.authz.annotation.RequiresAuthentication;
import org.graylog.plugins.views.search.permissions.SearchUser;
import org.graylog.plugins.views.search.views.ViewDTO;
import org.graylog.plugins.views.search.views.ViewService;
import org.graylog.plugins.views.search.views.ViewSummaryDTO;
import org.graylog2.database.PaginatedList;
import org.graylog2.rest.models.PaginatedResponse;
import org.graylog2.search.SearchQuery;
import org.graylog2.search.SearchQueryField;
import org.graylog2.search.SearchQueryParser;
import org.graylog2.shared.rest.resources.RestResource;

@RequiresAuthentication
@Api(value="Search/Saved")
@Produces(value={"application/json"})
@Path(value="/search/saved")
public class SavedSearchesResource
extends RestResource {
    private static final ImmutableMap<String, SearchQueryField> SEARCH_FIELD_MAPPING = ImmutableMap.builder().put((Object)"id", (Object)SearchQueryField.create("_id", SearchQueryField.Type.OBJECT_ID)).put((Object)"title", (Object)SearchQueryField.create("title")).build();
    private final ViewService dbService;
    private final SearchQueryParser searchQueryParser;

    @Inject
    public SavedSearchesResource(ViewService dbService) {
        this.dbService = dbService;
        this.searchQueryParser = new SearchQueryParser("title", (Map<String, SearchQueryField>)SEARCH_FIELD_MAPPING);
    }

    @GET
    @ApiOperation(value="Get a list of all searches")
    public PaginatedResponse<ViewSummaryDTO> views(@ApiParam(name="page") @QueryParam(value="page") @DefaultValue(value="1") int page, @ApiParam(name="per_page") @QueryParam(value="per_page") @DefaultValue(value="50") int perPage, @ApiParam(name="sort", value="The field to sort the result on", required=true, allowableValues="id,title,created_at") @DefaultValue(value="title") @QueryParam(value="sort") String sortField, @ApiParam(name="order", value="The sort direction", allowableValues="asc, desc") @DefaultValue(value="asc") @QueryParam(value="order") String order, @ApiParam(name="query") @QueryParam(value="query") String query, @Context SearchUser searchUser) {
        if (!ViewDTO.SORT_FIELDS.contains((Object)sortField.toLowerCase(Locale.ENGLISH))) {
            sortField = "title";
        }
        try {
            SearchQuery searchQuery = this.searchQueryParser.parse(query);
            PaginatedList<ViewSummaryDTO> result = this.dbService.searchSummariesPaginatedByType(ViewDTO.Type.SEARCH, searchQuery, searchUser::canReadView, order, sortField, page, perPage);
            return PaginatedResponse.create("views", result, query);
        }
        catch (IllegalArgumentException e) {
            throw new BadRequestException(e.getMessage(), (Throwable)e);
        }
    }
}

