/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.views.search.rest;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.auto.value.AutoValue;
import com.google.common.collect.ImmutableSet;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.graylog.plugins.views.search.Parameter;
import org.graylog.plugins.views.search.Query;
import org.graylog.plugins.views.search.Search;
import org.graylog.plugins.views.search.rest.AutoValue_SearchDTOv2;
import org.graylog.plugins.views.search.rest.QueryDTOv2;

@JsonAutoDetect
@JsonDeserialize(builder=Builder.class)
@AutoValue
public abstract class SearchDTOv2 {
    @Nullable
    @JsonProperty
    public abstract String id();

    @JsonProperty
    public abstract Set<QueryDTOv2> queries();

    @JsonProperty
    public abstract Set<Parameter> parameters();

    static SearchDTOv2 fromSearch(Search search) {
        return Builder.create().id(search.id()).parameters((Set<Parameter>)search.parameters()).queries(search.queries().stream().map(QueryDTOv2::fromQuery).collect(Collectors.toSet())).build();
    }

    public static Builder builder() {
        return Builder.create();
    }

    Search toSearch() {
        ImmutableSet queries = (ImmutableSet)this.queries().stream().map(QueryDTOv2::toQuery).collect(ImmutableSet.toImmutableSet());
        return Search.builder().id(this.id()).queries((ImmutableSet<Query>)queries).parameters((ImmutableSet<Parameter>)ImmutableSet.copyOf(this.parameters())).build();
    }

    @AutoValue.Builder
    public static abstract class Builder {
        @JsonProperty
        public abstract Builder id(String var1);

        public abstract String id();

        @JsonProperty
        public abstract Builder queries(Set<QueryDTOv2> var1);

        @JsonProperty
        public abstract Builder parameters(Set<Parameter> var1);

        public abstract SearchDTOv2 build();

        @JsonCreator
        static Builder create() {
            return new AutoValue_SearchDTOv2.Builder().queries((Set<QueryDTOv2>)ImmutableSet.of()).parameters((Set<Parameter>)ImmutableSet.of());
        }
    }
}

