/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.views.search.validation;

import java.util.Optional;
import javax.validation.constraints.NotNull;
import org.graylog.plugins.views.search.validation.ImmutableToken;
import org.graylog.plugins.views.search.validation.ParsedTerm;

final class AutoValue_ParsedTerm
extends ParsedTerm {
    private final String field;
    private final String value;
    private final Optional<ImmutableToken> keyToken;

    private AutoValue_ParsedTerm(String field, String value, Optional<ImmutableToken> keyToken) {
        this.field = field;
        this.value = value;
        this.keyToken = keyToken;
    }

    @Override
    public String field() {
        return this.field;
    }

    @Override
    public String value() {
        return this.value;
    }

    @Override
    public Optional<ImmutableToken> keyToken() {
        return this.keyToken;
    }

    public String toString() {
        return "ParsedTerm{field=" + this.field + ", value=" + this.value + ", keyToken=" + this.keyToken + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof ParsedTerm) {
            ParsedTerm that = (ParsedTerm)o;
            return this.field.equals(that.field()) && this.value.equals(that.value()) && this.keyToken.equals(that.keyToken());
        }
        return false;
    }

    public int hashCode() {
        int h$ = 1;
        h$ *= 1000003;
        h$ ^= this.field.hashCode();
        h$ *= 1000003;
        h$ ^= this.value.hashCode();
        h$ *= 1000003;
        return h$ ^= this.keyToken.hashCode();
    }

    static final class Builder
    extends ParsedTerm.Builder {
        private String field;
        private String value;
        private Optional<ImmutableToken> keyToken = Optional.empty();

        Builder() {
        }

        @Override
        public ParsedTerm.Builder field(@NotNull String field) {
            if (field == null) {
                throw new NullPointerException("Null field");
            }
            this.field = field;
            return this;
        }

        @Override
        public ParsedTerm.Builder value(@NotNull String value) {
            if (value == null) {
                throw new NullPointerException("Null value");
            }
            this.value = value;
            return this;
        }

        @Override
        public ParsedTerm.Builder keyToken(@NotNull ImmutableToken keyToken) {
            this.keyToken = Optional.of(keyToken);
            return this;
        }

        @Override
        public ParsedTerm build() {
            String missing = "";
            if (this.field == null) {
                missing = missing + " field";
            }
            if (this.value == null) {
                missing = missing + " value";
            }
            if (!missing.isEmpty()) {
                throw new IllegalStateException("Missing required properties:" + missing);
            }
            return new AutoValue_ParsedTerm(this.field, this.value, this.keyToken);
        }
    }
}

