/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.scheduler;

import com.google.inject.Binder;
import com.google.inject.assistedinject.FactoryModuleBuilder;
import com.google.inject.multibindings.OptionalBinder;
import org.graylog.scheduler.DefaultJobSchedulerConfig;
import org.graylog.scheduler.JobExecutionEngine;
import org.graylog.scheduler.JobSchedulerConfig;
import org.graylog.scheduler.JobSchedulerService;
import org.graylog.scheduler.JobTriggerUpdates;
import org.graylog.scheduler.audit.JobSchedulerAuditEventTypes;
import org.graylog.scheduler.clock.JobSchedulerClock;
import org.graylog.scheduler.clock.JobSchedulerSystemClock;
import org.graylog.scheduler.eventbus.JobSchedulerEventBus;
import org.graylog.scheduler.eventbus.JobSchedulerEventBusProvider;
import org.graylog.scheduler.rest.JobSchedulerResource;
import org.graylog.scheduler.worker.JobWorkerPool;
import org.graylog2.plugin.PluginModule;

public class JobSchedulerModule
extends PluginModule {
    protected void configure() {
        this.bind(JobSchedulerService.class).asEagerSingleton();
        this.bind(JobSchedulerClock.class).toInstance((Object)JobSchedulerSystemClock.INSTANCE);
        this.bind(JobSchedulerEventBus.class).toProvider(JobSchedulerEventBusProvider.class).asEagerSingleton();
        this.install(new FactoryModuleBuilder().build(JobExecutionEngine.Factory.class));
        this.install(new FactoryModuleBuilder().build(JobWorkerPool.Factory.class));
        this.install(new FactoryModuleBuilder().build(JobTriggerUpdates.Factory.class));
        OptionalBinder.newOptionalBinder((Binder)this.binder(), JobSchedulerConfig.class).setDefault().to(DefaultJobSchedulerConfig.class);
        this.addSystemRestResource(JobSchedulerResource.class);
        this.addInitializer(JobSchedulerService.class);
        this.addAuditEventTypes(JobSchedulerAuditEventTypes.class);
    }
}

