/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.scheduler;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.auto.value.AutoValue;
import java.util.Optional;
import javax.annotation.Nullable;
import org.graylog.scheduler.AutoValue_JobTriggerDto;
import org.graylog.scheduler.JobSchedule;
import org.graylog.scheduler.JobTriggerData;
import org.graylog.scheduler.JobTriggerLock;
import org.graylog.scheduler.JobTriggerStatus;
import org.graylog.scheduler.clock.JobSchedulerClock;
import org.graylog.scheduler.clock.JobSchedulerSystemClock;
import org.joda.time.DateTime;
import org.mongojack.Id;
import org.mongojack.ObjectId;

@JsonDeserialize(builder=Builder.class)
@AutoValue
public abstract class JobTriggerDto {
    private static final String FIELD_ID = "id";
    public static final String FIELD_JOB_DEFINITION_ID = "job_definition_id";
    static final String FIELD_START_TIME = "start_time";
    static final String FIELD_END_TIME = "end_time";
    static final String FIELD_NEXT_TIME = "next_time";
    private static final String FIELD_CREATED_AT = "created_at";
    static final String FIELD_UPDATED_AT = "updated_at";
    static final String FIELD_TRIGGERED_AT = "triggered_at";
    static final String FIELD_STATUS = "status";
    static final String FIELD_LOCK = "lock";
    static final String FIELD_SCHEDULE = "schedule";
    static final String FIELD_DATA = "data";

    @Id
    @ObjectId
    @Nullable
    @JsonProperty(value="id")
    public abstract String id();

    @JsonProperty(value="job_definition_id")
    public abstract String jobDefinitionId();

    @JsonProperty(value="start_time")
    public abstract DateTime startTime();

    @JsonProperty(value="end_time")
    public abstract Optional<DateTime> endTime();

    @JsonProperty(value="next_time")
    public abstract DateTime nextTime();

    @JsonProperty(value="created_at")
    public abstract DateTime createdAt();

    @JsonProperty(value="updated_at")
    public abstract DateTime updatedAt();

    @JsonProperty(value="triggered_at")
    public abstract Optional<DateTime> triggeredAt();

    @JsonProperty(value="status")
    public abstract JobTriggerStatus status();

    @JsonProperty(value="lock")
    public abstract JobTriggerLock lock();

    @JsonProperty(value="schedule")
    public abstract JobSchedule schedule();

    @JsonProperty(value="data")
    public abstract Optional<JobTriggerData> data();

    public static Builder builder() {
        return Builder.create();
    }

    public static Builder builderWithClock(JobSchedulerClock clock) {
        return Builder.create(clock);
    }

    public abstract Builder toBuilder();

    @AutoValue.Builder
    public static abstract class Builder {
        @JsonCreator
        public static Builder create() {
            return Builder.create(new JobSchedulerSystemClock());
        }

        public static Builder create(JobSchedulerClock clock) {
            DateTime now = clock.nowUTC();
            return new AutoValue_JobTriggerDto.Builder().startTime(now).createdAt(now).updatedAt(now).nextTime(now).status(JobTriggerStatus.RUNNABLE).lock(JobTriggerLock.empty());
        }

        @Id
        @ObjectId
        @JsonProperty(value="id")
        public abstract Builder id(String var1);

        @JsonProperty(value="job_definition_id")
        public abstract Builder jobDefinitionId(String var1);

        @JsonProperty(value="start_time")
        public abstract Builder startTime(DateTime var1);

        @JsonProperty(value="end_time")
        public abstract Builder endTime(@Nullable DateTime var1);

        @JsonProperty(value="next_time")
        public abstract Builder nextTime(DateTime var1);

        @JsonProperty(value="created_at")
        public abstract Builder createdAt(DateTime var1);

        @JsonProperty(value="updated_at")
        public abstract Builder updatedAt(DateTime var1);

        @JsonProperty(value="triggered_at")
        public abstract Builder triggeredAt(@Nullable DateTime var1);

        @JsonProperty(value="status")
        public abstract Builder status(JobTriggerStatus var1);

        @JsonProperty(value="lock")
        public abstract Builder lock(JobTriggerLock var1);

        @JsonProperty(value="schedule")
        public abstract Builder schedule(JobSchedule var1);

        @JsonProperty(value="data")
        public abstract Builder data(@Nullable JobTriggerData var1);

        public abstract JobTriggerDto build();
    }
}

