/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.rest.resources.cluster;

import com.codahale.metrics.annotation.Timed;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.io.IOException;
import java.util.concurrent.ExecutorService;
import javax.inject.Inject;
import javax.inject.Named;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.Response;
import org.apache.shiro.authz.annotation.RequiresAuthentication;
import org.graylog2.cluster.Node;
import org.graylog2.cluster.NodeNotFoundException;
import org.graylog2.cluster.NodeService;
import org.graylog2.rest.RemoteInterfaceProvider;
import org.graylog2.rest.models.system.plugins.responses.PluginList;
import org.graylog2.rest.resources.cluster.ClusterSystemResource;
import org.graylog2.shared.rest.resources.ProxiedResource;
import org.graylog2.shared.rest.resources.system.RemoteSystemPluginResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import retrofit2.Response;

@RequiresAuthentication
@Api(value="Cluster/Plugins", description="Plugin information for any node in the cluster")
@Path(value="/cluster/{nodeId}/plugins")
@Produces(value={"application/json"})
public class ClusterSystemPluginResource
extends ProxiedResource {
    private static final Logger LOG = LoggerFactory.getLogger(ClusterSystemResource.class);

    @Inject
    public ClusterSystemPluginResource(NodeService nodeService, RemoteInterfaceProvider remoteInterfaceProvider, @Context HttpHeaders httpHeaders, @Named(value="proxiedRequestsExecutorService") ExecutorService executorService) throws NodeNotFoundException {
        super(httpHeaders, nodeService, remoteInterfaceProvider, executorService);
    }

    @GET
    @Timed
    @ApiOperation(value="List all installed plugins on the given node")
    public PluginList list(@ApiParam(name="nodeId", value="The id of the node where processing will be paused.", required=true) @PathParam(value="nodeId") String nodeId) throws IOException, NodeNotFoundException {
        Node targetNode = this.nodeService.byNodeId(nodeId);
        RemoteSystemPluginResource remoteSystemPluginResource = this.remoteInterfaceProvider.get(targetNode, this.authenticationToken, RemoteSystemPluginResource.class);
        Response response = remoteSystemPluginResource.list().execute();
        if (response.isSuccessful()) {
            return (PluginList)response.body();
        }
        LOG.warn("Unable to get plugin list on node {}: {}", (Object)nodeId, (Object)response.message());
        throw new WebApplicationException(response.message(), Response.Status.BAD_GATEWAY);
    }
}

