/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.rest.resources.system.contentpacks;

import com.codahale.metrics.annotation.Timed;
import com.fasterxml.jackson.annotation.JsonView;
import com.google.common.collect.ImmutableMap;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.net.URI;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.ws.rs.BadRequestException;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.apache.shiro.authz.annotation.RequiresAuthentication;
import org.bson.types.ObjectId;
import org.graylog2.audit.jersey.AuditEvent;
import org.graylog2.contentpacks.ContentPackInstallationPersistenceService;
import org.graylog2.contentpacks.ContentPackPersistenceService;
import org.graylog2.contentpacks.ContentPackService;
import org.graylog2.contentpacks.model.ContentPack;
import org.graylog2.contentpacks.model.ContentPackInstallation;
import org.graylog2.contentpacks.model.ContentPackUninstallDetails;
import org.graylog2.contentpacks.model.ContentPackUninstallation;
import org.graylog2.contentpacks.model.ContentPackView;
import org.graylog2.contentpacks.model.ModelId;
import org.graylog2.contentpacks.model.Revisioned;
import org.graylog2.contentpacks.model.constraints.ConstraintCheckResult;
import org.graylog2.plugin.database.users.User;
import org.graylog2.rest.models.system.contentpacks.responses.ContentPackInstallationRequest;
import org.graylog2.rest.models.system.contentpacks.responses.ContentPackInstallationsResponse;
import org.graylog2.rest.models.system.contentpacks.responses.ContentPackList;
import org.graylog2.rest.models.system.contentpacks.responses.ContentPackMetadata;
import org.graylog2.rest.models.system.contentpacks.responses.ContentPackResponse;
import org.graylog2.rest.models.system.contentpacks.responses.ContentPackRevisions;
import org.graylog2.shared.rest.resources.RestResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RequiresAuthentication
@Api(value="System/ContentPacks", description="Content Packs")
@Path(value="/system/content_packs")
@Produces(value={"application/json"})
public class ContentPackResource
extends RestResource {
    private static final Logger LOG = LoggerFactory.getLogger(ContentPackResource.class);
    private final ContentPackService contentPackService;
    private final ContentPackPersistenceService contentPackPersistenceService;
    private final ContentPackInstallationPersistenceService contentPackInstallationPersistenceService;

    @Inject
    public ContentPackResource(ContentPackService contentPackService, ContentPackPersistenceService contentPackPersistenceService, ContentPackInstallationPersistenceService contentPackInstallationPersistenceService) {
        this.contentPackService = contentPackService;
        this.contentPackPersistenceService = contentPackPersistenceService;
        this.contentPackInstallationPersistenceService = contentPackInstallationPersistenceService;
    }

    @GET
    @Timed
    @ApiOperation(value="List available content packs")
    @ApiResponses(value={@ApiResponse(code=500, message="Error loading content packs")})
    @JsonView(value={ContentPackView.HttpView.class})
    public ContentPackList listContentPacks() {
        this.checkPermission("contentpack:read");
        Set<ContentPack> contentPacks = this.contentPackPersistenceService.loadAll();
        Set<ModelId> contentPackIds = contentPacks.stream().map(x -> x.id()).collect(Collectors.toSet());
        Map<ModelId, Map<Integer, ContentPackMetadata>> metaData = this.contentPackInstallationPersistenceService.getInstallationMetadata(contentPackIds);
        return ContentPackList.create(contentPacks.size(), contentPacks, metaData);
    }

    @GET
    @Path(value="latest")
    @Timed
    @ApiOperation(value="List latest available content packs")
    @ApiResponses(value={@ApiResponse(code=500, message="Error loading content packs")})
    @JsonView(value={ContentPackView.HttpView.class})
    public ContentPackList listLatestContentPacks() {
        this.checkPermission("contentpack:read");
        Set<ContentPack> contentPacks = this.contentPackPersistenceService.loadAllLatest();
        Set<ModelId> contentPackIds = contentPacks.stream().map(x -> x.id()).collect(Collectors.toSet());
        Map<ModelId, Map<Integer, ContentPackMetadata>> metaData = this.contentPackInstallationPersistenceService.getInstallationMetadata(contentPackIds);
        return ContentPackList.create(contentPacks.size(), contentPacks, metaData);
    }

    @GET
    @Path(value="{contentPackId}")
    @Timed
    @ApiOperation(value="List all revisions of a content pack")
    @ApiResponses(value={@ApiResponse(code=500, message="Error loading content packs")})
    @JsonView(value={ContentPackView.HttpView.class})
    public ContentPackRevisions listContentPackRevisions(@ApiParam(name="contentPackId", value="Content pack ID", required=true) @PathParam(value="contentPackId") ModelId id) {
        this.checkPermission("contentpack:read", id.toString());
        Set<ContentPack> contentPacks = this.contentPackPersistenceService.findAllById(id);
        Map<Integer, ContentPack> contentPackMap = contentPacks.stream().collect(Collectors.toMap(Revisioned::revision, Function.identity()));
        Map<Integer, Set<ConstraintCheckResult>> constraintMap = contentPacks.stream().collect(Collectors.toMap(Revisioned::revision, this.contentPackService::checkConstraints));
        if (contentPackMap.size() <= 0) {
            throw new NotFoundException("Content pack " + id + " not found!");
        }
        return ContentPackRevisions.create(contentPackMap, constraintMap);
    }

    @GET
    @Path(value="{contentPackId}/{revision}")
    @Timed
    @ApiOperation(value="Get a revision of a content pack")
    @ApiResponses(value={@ApiResponse(code=500, message="Error loading content packs")})
    @JsonView(value={ContentPackView.HttpView.class})
    public ContentPackResponse getContentPackRevisions(@ApiParam(name="contentPackId", value="Content pack ID", required=true) @PathParam(value="contentPackId") ModelId id, @ApiParam(name="revision", value="Content pack revision", required=true) @PathParam(value="revision") int revision) {
        this.checkPermission("contentpack:read");
        ContentPack contentPack = this.contentPackPersistenceService.findByIdAndRevision(id, revision).orElseThrow(() -> new NotFoundException("Content pack " + id + " with revision " + revision + " not found!"));
        Set<ConstraintCheckResult> constraints = this.contentPackService.checkConstraints(contentPack);
        return ContentPackResponse.create(contentPack, constraints);
    }

    @GET
    @Path(value="{contentPackId}/{revision}/download")
    @Timed
    @ApiOperation(value="Download a revision of a content pack")
    @ApiResponses(value={@ApiResponse(code=500, message="Error loading content packs")})
    @JsonView(value={ContentPackView.HttpView.class})
    public ContentPack downloadContentPackRevisions(@ApiParam(name="contentPackId", value="Content pack ID", required=true) @PathParam(value="contentPackId") ModelId id, @ApiParam(name="revision", value="Content pack revision", required=true) @PathParam(value="revision") int revision) {
        this.checkPermission("contentpack:read", id.toString());
        ContentPack contentPack = this.contentPackPersistenceService.findByIdAndRevision(id, revision).orElseThrow(() -> new NotFoundException("Content pack " + id + " with revision " + revision + " not found!"));
        return contentPack;
    }

    @POST
    @Timed
    @Consumes(value={"application/json"})
    @ApiOperation(value="Upload a content pack")
    @ApiResponses(value={@ApiResponse(code=400, message="Missing or invalid content pack"), @ApiResponse(code=500, message="Error while saving content pack")})
    @AuditEvent(type="server:content_pack:create")
    @JsonView(value={ContentPackView.HttpView.class})
    public Response createContentPack(@ApiParam(name="Request body", value="Content pack", required=true) @NotNull @Valid ContentPack contentPack) {
        this.checkPermission("contentpack:create");
        ContentPack pack = this.contentPackPersistenceService.filterMissingResourcesAndInsert(contentPack).orElseThrow(() -> new BadRequestException("Content pack " + contentPack.id() + " with this revision " + contentPack.revision() + " already found!"));
        URI packUri = this.getUriBuilderToSelf().path(ContentPackResource.class).path("{contentPackId}").build(new Object[]{pack.id()});
        return Response.created((URI)packUri).build();
    }

    @DELETE
    @Timed
    @ApiOperation(value="Delete all revisions of a content pack")
    @ApiResponses(value={@ApiResponse(code=400, message="Missing or invalid content pack"), @ApiResponse(code=500, message="Error while saving content pack")})
    @AuditEvent(type="server:content_pack:delete")
    @Path(value="{contentPackId}")
    @JsonView(value={ContentPackView.HttpView.class})
    public void deleteContentPack(@ApiParam(name="contentPackId", value="Content Pack ID", required=true) @PathParam(value="contentPackId") ModelId contentPackId) {
        this.checkPermission("contentpack:delete", contentPackId.toString());
        if (!this.contentPackInstallationPersistenceService.findByContentPackId(contentPackId).isEmpty()) {
            throw new BadRequestException("Content pack " + contentPackId + " with all its revisions can't be deleted: There are still installations of this content pack");
        }
        int deleted = this.contentPackPersistenceService.deleteById(contentPackId);
        LOG.debug("Deleted {} content packs with id {}", (Object)deleted, (Object)contentPackId);
    }

    @DELETE
    @Timed
    @ApiOperation(value="Delete one revision of a content pack")
    @ApiResponses(value={@ApiResponse(code=400, message="Missing or invalid content pack"), @ApiResponse(code=500, message="Error while saving content pack")})
    @AuditEvent(type="server:content_pack:delete_rev")
    @Path(value="{contentPackId}/{revision}")
    @JsonView(value={ContentPackView.HttpView.class})
    public void deleteContentPack(@ApiParam(name="contentPackId", value="Content Pack ID", required=true) @PathParam(value="contentPackId") ModelId contentPackId, @ApiParam(name="revision", value="Content Pack revision", required=true) @PathParam(value="revision") int revision) {
        this.checkPermission("contentpack:delete", contentPackId.toString());
        if (!this.contentPackInstallationPersistenceService.findByContentPackIdAndRevision(contentPackId, revision).isEmpty()) {
            throw new BadRequestException("Content pack " + contentPackId + " and revision " + revision + " can't be deleted: There are still installations of this content pack revision.");
        }
        int deleted = this.contentPackPersistenceService.deleteByIdAndRevision(contentPackId, revision);
        LOG.debug("Deleted {} content packs with id {} and revision", new Object[]{deleted, contentPackId, revision});
    }

    @POST
    @Path(value="{contentPackId}/{revision}/installations")
    @Timed
    @ApiOperation(value="Install a revision of a content pack")
    @ApiResponses(value={@ApiResponse(code=500, message="Error loading content packs")})
    @AuditEvent(type="server:content_pack:install")
    @JsonView(value={ContentPackView.HttpView.class})
    public ContentPackInstallation installContentPack(@ApiParam(name="contentPackId", value="Content pack ID", required=true) @PathParam(value="contentPackId") ModelId id, @ApiParam(name="revision", value="Content pack revision", required=true) @PathParam(value="revision") int revision, @ApiParam(name="installation request", value="Content pack installation request", required=true) @Valid @NotNull ContentPackInstallationRequest contentPackInstallationRequest) {
        this.checkPermission("contentpack:install", id.toString());
        ContentPack contentPack = this.contentPackPersistenceService.findByIdAndRevision(id, revision).orElseThrow(() -> new NotFoundException("Content pack " + id + " with revision " + revision + " not found!"));
        User currentUser = this.getCurrentUser();
        String userName = currentUser == null ? "unknown" : currentUser.getName();
        ContentPackInstallation installation = this.contentPackService.installContentPack(contentPack, contentPackInstallationRequest.parameters(), contentPackInstallationRequest.comment(), userName);
        return installation;
    }

    @GET
    @Path(value="{contentPackId}/installations")
    @Timed
    @ApiOperation(value="Get details about the installations of a content pack")
    @ApiResponses(value={@ApiResponse(code=500, message="Error loading content packs")})
    @JsonView(value={ContentPackView.HttpView.class})
    public ContentPackInstallationsResponse listContentPackInstallationsById(@ApiParam(name="contentPackId", value="Content pack ID", required=true) @PathParam(value="contentPackId") ModelId id) {
        this.checkPermission("contentpack:read", id.toString());
        Set<ContentPackInstallation> installations = this.contentPackInstallationPersistenceService.findByContentPackId(id);
        return ContentPackInstallationsResponse.create(installations.size(), installations);
    }

    @GET
    @Path(value="{contentPackId}/installations/{installationId}/uninstall_details")
    @Timed
    @ApiOperation(value="Get details about which entities will actually be uninstalled")
    @ApiResponses(value={@ApiResponse(code=500, message="Error loading content packs")})
    @JsonView(value={ContentPackView.HttpView.class})
    public ContentPackUninstallDetails uninstallDetails(@ApiParam(name="contentPackId", value="Content pack ID", required=true) @PathParam(value="contentPackId") ModelId id, @ApiParam(name="installationId", value="Installation ID", required=true) @PathParam(value="installationId") String installationId) {
        ContentPackInstallation installation = this.contentPackInstallationPersistenceService.findById(new ObjectId(installationId)).orElseThrow(() -> new NotFoundException("Couldn't find installation " + installationId));
        ContentPack contentPack = this.contentPackPersistenceService.findByIdAndRevision(installation.contentPackId(), installation.contentPackRevision()).orElseThrow(() -> new NotFoundException("Couldn't find content pack " + installation.contentPackId() + " rev " + installation.contentPackRevision()));
        return this.contentPackService.getUninstallDetails(contentPack, installation);
    }

    @DELETE
    @Path(value="{contentPackId}/installations/{installationId}")
    @Timed
    @ApiOperation(value="Uninstall a content pack installation")
    @ApiResponses(value={@ApiResponse(code=500, message="Error loading content packs")})
    @AuditEvent(type="server:content_pack:uninstall")
    @JsonView(value={ContentPackView.HttpView.class})
    public Response deleteContentPackInstallationById(@ApiParam(name="contentPackId", value="Content pack ID", required=true) @PathParam(value="contentPackId") ModelId contentPackId, @ApiParam(name="installationId", value="Installation ID", required=true) @PathParam(value="installationId") String installationId) {
        this.checkPermission("contentpack:uninstall", contentPackId.toString());
        ContentPackInstallation installation = this.contentPackInstallationPersistenceService.findById(new ObjectId(installationId)).orElseThrow(() -> new NotFoundException("Couldn't find installation " + installationId));
        ContentPack contentPack = this.contentPackPersistenceService.findByIdAndRevision(installation.contentPackId(), installation.contentPackRevision()).orElseThrow(() -> new NotFoundException("Couldn't find content pack " + installation.contentPackId() + " rev " + installation.contentPackRevision()));
        ContentPackUninstallation removedInstallation = this.contentPackService.uninstallContentPack(contentPack, installation);
        return Response.ok((Object)ImmutableMap.of((Object)"content_pack", (Object)contentPack, (Object)"uninstalled", (Object)removedInstallation)).build();
    }
}

