/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.streams;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.auto.value.AutoValue;
import java.util.Collection;
import javax.annotation.Nullable;
import org.bson.types.ObjectId;
import org.graylog2.plugin.streams.Stream;
import org.graylog2.plugin.streams.StreamRule;
import org.graylog2.rest.models.alarmcallbacks.requests.AlertReceivers;
import org.graylog2.rest.models.streams.alerts.AlertConditionSummary;
import org.graylog2.streams.$AutoValue_StreamDTO;

@JsonAutoDetect
@JsonDeserialize(builder=Builder.class)
@AutoValue
public abstract class StreamDTO {
    public static final String FIELD_ID = "_id";
    public static final String FIELD_TITLE = "title";
    public static final String FIELD_DESCRIPTION = "description";
    public static final String FIELD_RULES = "rules";
    public static final String FIELD_OUTPUTS = "outputs";
    public static final String FIELD_CONTENT_PACK = "content_pack";
    public static final String FIELD_ALERT_RECEIVERS = "alert_receivers";
    public static final String FIELD_DISABLED = "disabled";
    public static final String FIELD_CREATED_AT = "created_at";
    public static final String FIELD_CREATOR_USER_ID = "creator_user_id";
    public static final String FIELD_MATCHING_TYPE = "matching_type";
    public static final String FIELD_DEFAULT_STREAM = "is_default_stream";
    public static final String FIELD_REMOVE_MATCHES_FROM_DEFAULT_STREAM = "remove_matches_from_default_stream";
    public static final String FIELD_INDEX_SET_ID = "index_set_id";
    public static final String EMBEDDED_ALERT_CONDITIONS = "alert_conditions";
    public static final String FIELD_IS_EDITABLE = "is_editable";

    @JsonProperty(value="id")
    public abstract String id();

    @JsonProperty(value="creator_user_id")
    public abstract String creatorUserId();

    @JsonProperty(value="outputs")
    @Nullable
    public abstract Collection<ObjectId> outputs();

    @JsonProperty(value="matching_type")
    public abstract String matchingType();

    @JsonProperty(value="description")
    @Nullable
    public abstract String description();

    @JsonProperty(value="created_at")
    public abstract String createdAt();

    @JsonProperty(value="rules")
    @Nullable
    public abstract Collection<StreamRule> rules();

    @JsonProperty(value="disabled")
    public abstract boolean disabled();

    @JsonProperty(value="alert_conditions")
    @Nullable
    public abstract Collection<AlertConditionSummary> alertConditions();

    @JsonProperty(value="alert_receivers")
    @Nullable
    public abstract AlertReceivers alertReceivers();

    @JsonProperty(value="title")
    public abstract String title();

    @JsonProperty(value="content_pack")
    @Nullable
    public abstract String contentPack();

    @JsonProperty(value="is_default")
    @Nullable
    public abstract Boolean isDefault();

    @JsonProperty(value="remove_matches_from_default_stream")
    @Nullable
    public abstract Boolean removeMatchesFromDefaultStream();

    @JsonProperty(value="index_set_id")
    public abstract String indexSetId();

    @JsonProperty(value="is_editable")
    public abstract boolean isEditable();

    public abstract Builder toBuilder();

    static Builder builder() {
        return Builder.create();
    }

    @AutoValue.Builder
    public static abstract class Builder {
        @JsonCreator
        public static Builder create() {
            return new $AutoValue_StreamDTO.Builder().matchingType(Stream.MatchingType.AND.toString()).isDefault(false).isEditable(false).removeMatchesFromDefaultStream(false);
        }

        @JsonProperty(value="_id")
        public abstract Builder id(String var1);

        @JsonProperty(value="creator_user_id")
        public abstract Builder creatorUserId(String var1);

        @JsonProperty(value="outputs")
        public abstract Builder outputs(Collection<ObjectId> var1);

        @JsonProperty(value="matching_type")
        public abstract Builder matchingType(String var1);

        @JsonProperty(value="description")
        public abstract Builder description(String var1);

        @JsonProperty(value="created_at")
        public abstract Builder createdAt(String var1);

        @JsonProperty(value="content_pack")
        public abstract Builder contentPack(String var1);

        @JsonProperty(value="disabled")
        public abstract Builder disabled(boolean var1);

        @JsonProperty(value="alert_conditions")
        public abstract Builder alertConditions(Collection<AlertConditionSummary> var1);

        @JsonProperty(value="rules")
        public abstract Builder rules(Collection<StreamRule> var1);

        @JsonProperty(value="alert_receivers")
        public abstract Builder alertReceivers(AlertReceivers var1);

        @JsonProperty(value="title")
        public abstract Builder title(String var1);

        @JsonProperty(value="is_default_stream")
        public abstract Builder isDefault(Boolean var1);

        @JsonProperty(value="remove_matches_from_default_stream")
        public abstract Builder removeMatchesFromDefaultStream(Boolean var1);

        @JsonProperty(value="index_set_id")
        public abstract Builder indexSetId(String var1);

        @JsonProperty(value="is_editable")
        public abstract Builder isEditable(boolean var1);

        public abstract String id();

        public abstract StreamDTO autoBuild();

        public StreamDTO build() {
            this.isEditable(Stream.streamIsEditable(this.id()));
            return this.autoBuild();
        }
    }
}

