/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.events.context;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.auto.value.AutoValue;
import com.google.common.collect.ImmutableMap;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.graylog.events.context.AutoValue_EventDefinitionContextService_SchedulerCtx;
import org.graylog.events.processor.EventDefinitionDto;
import org.graylog.scheduler.DBJobDefinitionService;
import org.graylog.scheduler.DBJobTriggerService;
import org.graylog.scheduler.JobDefinitionDto;
import org.graylog.scheduler.JobTriggerData;
import org.graylog.scheduler.JobTriggerDto;
import org.graylog.scheduler.JobTriggerStatus;
import org.joda.time.DateTime;
import org.mongojack.DBQuery;

public class EventDefinitionContextService {
    private final DBJobDefinitionService jobDefinitionService;
    private final DBJobTriggerService jobTriggerService;

    @Inject
    public EventDefinitionContextService(DBJobDefinitionService jobDefinitionService, DBJobTriggerService jobTriggerService) {
        this.jobDefinitionService = jobDefinitionService;
        this.jobTriggerService = jobTriggerService;
    }

    public ImmutableMap<String, Object> contextFor(List<EventDefinitionDto> eventDefinitions) {
        return ImmutableMap.of((Object)"scheduler", this.schedulerContext(eventDefinitions));
    }

    public ImmutableMap<String, Object> contextFor(EventDefinitionDto eventDefinition) {
        ImmutableMap<String, SchedulerCtx> schedulerContext = this.schedulerContext(Collections.singletonList(eventDefinition));
        return ImmutableMap.of((Object)"scheduler", (Object)schedulerContext.get((Object)eventDefinition.id()));
    }

    private Map<String, List<JobDefinitionDto>> getJobDefinitions(List<EventDefinitionDto> eventDefinitions) {
        Set eventDefinitionIds = eventDefinitions.stream().map(EventDefinitionDto::id).collect(Collectors.toSet());
        return this.jobDefinitionService.getAllByConfigField("event_definition_id", eventDefinitionIds);
    }

    private Map<String, List<JobTriggerDto>> getJobTriggers(Map<String, List<JobDefinitionDto>> jobDefinitions) {
        Set<String> jobDefinitionIds = jobDefinitions.values().stream().flatMap(Collection::stream).map(JobDefinitionDto::id).collect(Collectors.toSet());
        return this.jobTriggerService.getForJobs(jobDefinitionIds);
    }

    private long getQueuedNotifications(EventDefinitionDto eventDefinition) {
        DBQuery.Query query = DBQuery.and((DBQuery.Query[])new DBQuery.Query[]{DBQuery.is((String)"status", (Object)((Object)JobTriggerStatus.RUNNABLE)), DBQuery.is((String)"data.type", (Object)"notification-execution-v1"), DBQuery.is((String)"data.event_dto.event_definition_id", (Object)eventDefinition.id())});
        return this.jobTriggerService.countByQuery(query);
    }

    private ImmutableMap<String, SchedulerCtx> schedulerContext(List<EventDefinitionDto> eventDefinitions) {
        Map<String, List<JobDefinitionDto>> jobDefinitions = this.getJobDefinitions(eventDefinitions);
        Map<String, List<JobTriggerDto>> jobTriggers = this.getJobTriggers(jobDefinitions);
        ImmutableMap.Builder ctx = ImmutableMap.builder();
        for (EventDefinitionDto eventDefinition : eventDefinitions) {
            if (eventDefinition.id() == null) {
                throw new IllegalStateException("Event definition doesn't have an ID: " + eventDefinition);
            }
            if (!jobDefinitions.containsKey(eventDefinition.id())) {
                ctx.put((Object)eventDefinition.id(), (Object)SchedulerCtx.unscheduled());
                continue;
            }
            if (jobDefinitions.get(eventDefinition.id()).size() > 1) {
                throw new IllegalStateException("Cannot handle multiple job definitions for a single event definition");
            }
            JobDefinitionDto jobDefinition = jobDefinitions.get(eventDefinition.id()).get(0);
            JobTriggerDto trigger = jobTriggers.get(jobDefinition.id()).get(0);
            if (trigger == null) continue;
            ctx.put((Object)eventDefinition.id(), (Object)SchedulerCtx.scheduled(trigger, this.getQueuedNotifications(eventDefinition)));
        }
        return ctx.build();
    }

    @AutoValue
    public static abstract class SchedulerCtx {
        @JsonProperty(value="is_scheduled")
        public abstract boolean isScheduled();

        @JsonProperty(value="status")
        public abstract Optional<JobTriggerStatus> status();

        @JsonProperty(value="next_time")
        public abstract Optional<DateTime> nextTime();

        @JsonProperty(value="triggered_at")
        public abstract Optional<DateTime> triggeredAt();

        @JsonProperty(value="queued_notifications")
        public abstract long queuedNotifications();

        @JsonProperty(value="data")
        public abstract Optional<JobTriggerData> data();

        public static SchedulerCtx unscheduled() {
            return SchedulerCtx.create(false, null, 0L);
        }

        public static SchedulerCtx scheduled(JobTriggerDto trigger, long queuedNotifications) {
            return SchedulerCtx.create(true, trigger, queuedNotifications);
        }

        private static SchedulerCtx create(boolean isScheduled, JobTriggerDto trigger, long queuedNotifications) {
            Optional<JobTriggerDto> optionalTrigger = Optional.ofNullable(trigger);
            return new AutoValue_EventDefinitionContextService_SchedulerCtx(isScheduled, optionalTrigger.map(JobTriggerDto::status), optionalTrigger.map(JobTriggerDto::nextTime), optionalTrigger.flatMap(JobTriggerDto::triggeredAt), queuedNotifications, optionalTrigger.flatMap(JobTriggerDto::data));
        }
    }
}

