/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.events.notifications;

import java.util.Optional;
import javax.annotation.Nullable;
import org.graylog.events.event.EventDto;
import org.graylog.events.notifications.EventNotificationConfig;
import org.graylog.events.notifications.EventNotificationContext;
import org.graylog.events.processor.EventDefinitionDto;
import org.graylog.scheduler.JobTriggerDto;

final class AutoValue_EventNotificationContext
extends EventNotificationContext {
    private final String notificationId;
    private final EventNotificationConfig notificationConfig;
    private final EventDto event;
    private final Optional<EventDefinitionDto> eventDefinition;
    private final Optional<JobTriggerDto> jobTrigger;

    private AutoValue_EventNotificationContext(String notificationId, EventNotificationConfig notificationConfig, EventDto event, Optional<EventDefinitionDto> eventDefinition, Optional<JobTriggerDto> jobTrigger) {
        this.notificationId = notificationId;
        this.notificationConfig = notificationConfig;
        this.event = event;
        this.eventDefinition = eventDefinition;
        this.jobTrigger = jobTrigger;
    }

    @Override
    public String notificationId() {
        return this.notificationId;
    }

    @Override
    public EventNotificationConfig notificationConfig() {
        return this.notificationConfig;
    }

    @Override
    public EventDto event() {
        return this.event;
    }

    @Override
    public Optional<EventDefinitionDto> eventDefinition() {
        return this.eventDefinition;
    }

    @Override
    public Optional<JobTriggerDto> jobTrigger() {
        return this.jobTrigger;
    }

    public String toString() {
        return "EventNotificationContext{notificationId=" + this.notificationId + ", notificationConfig=" + this.notificationConfig + ", event=" + this.event + ", eventDefinition=" + this.eventDefinition + ", jobTrigger=" + this.jobTrigger + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof EventNotificationContext) {
            EventNotificationContext that = (EventNotificationContext)o;
            return this.notificationId.equals(that.notificationId()) && this.notificationConfig.equals(that.notificationConfig()) && this.event.equals(that.event()) && this.eventDefinition.equals(that.eventDefinition()) && this.jobTrigger.equals(that.jobTrigger());
        }
        return false;
    }

    public int hashCode() {
        int h$ = 1;
        h$ *= 1000003;
        h$ ^= this.notificationId.hashCode();
        h$ *= 1000003;
        h$ ^= this.notificationConfig.hashCode();
        h$ *= 1000003;
        h$ ^= this.event.hashCode();
        h$ *= 1000003;
        h$ ^= this.eventDefinition.hashCode();
        h$ *= 1000003;
        return h$ ^= this.jobTrigger.hashCode();
    }

    @Override
    public EventNotificationContext.Builder toBuilder() {
        return new Builder(this);
    }

    static final class Builder
    extends EventNotificationContext.Builder {
        private String notificationId;
        private EventNotificationConfig notificationConfig;
        private EventDto event;
        private Optional<EventDefinitionDto> eventDefinition = Optional.empty();
        private Optional<JobTriggerDto> jobTrigger = Optional.empty();

        Builder() {
        }

        private Builder(EventNotificationContext source) {
            this.notificationId = source.notificationId();
            this.notificationConfig = source.notificationConfig();
            this.event = source.event();
            this.eventDefinition = source.eventDefinition();
            this.jobTrigger = source.jobTrigger();
        }

        @Override
        public EventNotificationContext.Builder notificationId(String notificationId) {
            if (notificationId == null) {
                throw new NullPointerException("Null notificationId");
            }
            this.notificationId = notificationId;
            return this;
        }

        @Override
        public EventNotificationContext.Builder notificationConfig(EventNotificationConfig notificationConfig) {
            if (notificationConfig == null) {
                throw new NullPointerException("Null notificationConfig");
            }
            this.notificationConfig = notificationConfig;
            return this;
        }

        @Override
        public EventNotificationContext.Builder event(EventDto event) {
            if (event == null) {
                throw new NullPointerException("Null event");
            }
            this.event = event;
            return this;
        }

        @Override
        public EventNotificationContext.Builder eventDefinition(@Nullable EventDefinitionDto eventDefinition) {
            this.eventDefinition = Optional.ofNullable(eventDefinition);
            return this;
        }

        @Override
        public EventNotificationContext.Builder jobTrigger(JobTriggerDto jobTrigger) {
            this.jobTrigger = Optional.of(jobTrigger);
            return this;
        }

        @Override
        public EventNotificationContext build() {
            String missing = "";
            if (this.notificationId == null) {
                missing = missing + " notificationId";
            }
            if (this.notificationConfig == null) {
                missing = missing + " notificationConfig";
            }
            if (this.event == null) {
                missing = missing + " event";
            }
            if (!missing.isEmpty()) {
                throw new IllegalStateException("Missing required properties:" + missing);
            }
            return new AutoValue_EventNotificationContext(this.notificationId, this.notificationConfig, this.event, this.eventDefinition, this.jobTrigger);
        }
    }
}

