/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.pipelineprocessor.functions.lookup;

import com.google.common.collect.ImmutableList;
import com.google.inject.Inject;
import com.google.inject.TypeLiteral;
import java.util.List;
import org.graylog.plugins.pipelineprocessor.EvaluationContext;
import org.graylog.plugins.pipelineprocessor.ast.functions.AbstractFunction;
import org.graylog.plugins.pipelineprocessor.ast.functions.FunctionArgs;
import org.graylog.plugins.pipelineprocessor.ast.functions.FunctionDescriptor;
import org.graylog.plugins.pipelineprocessor.ast.functions.ParameterDescriptor;
import org.graylog2.lookup.LookupTableService;
import org.graylog2.plugin.lookup.LookupResult;

public class LookupStringList
extends AbstractFunction<List<String>> {
    public static final String NAME = "lookup_string_list";
    private final ParameterDescriptor<String, LookupTableService.Function> lookupTableParam = ParameterDescriptor.string("lookup_table", LookupTableService.Function.class).description("The existing lookup table to use to lookup the given key").transform(tableName -> lookupTableService.newBuilder().lookupTable((String)tableName).build()).build();
    private final ParameterDescriptor<Object, Object> keyParam = ParameterDescriptor.object("key").description("The key to lookup in the table").build();
    private final ParameterDescriptor<List, List> defaultParam = ParameterDescriptor.type("default", List.class).description("The default list value that should be used if there is no lookup result").optional().build();

    @Inject
    public LookupStringList(LookupTableService lookupTableService) {
    }

    @Override
    public List<String> evaluate(FunctionArgs args, EvaluationContext context) {
        Object key = this.keyParam.required(args, context);
        if (key == null) {
            return this.defaultParam.optional(args, context).orElse((List)ImmutableList.of());
        }
        LookupTableService.Function table = this.lookupTableParam.required(args, context);
        if (table == null) {
            return this.defaultParam.optional(args, context).orElse((List)ImmutableList.of());
        }
        LookupResult result = table.lookup(key);
        if (result == null || result.isEmpty()) {
            return this.defaultParam.optional(args, context).orElse((List)ImmutableList.of());
        }
        return result.stringListValue();
    }

    @Override
    public FunctionDescriptor<List<String>> descriptor() {
        return FunctionDescriptor.builder().name(NAME).description("Looks up a string list value in the named lookup table.").params(this.lookupTableParam, this.keyParam, this.defaultParam).returnType(new TypeLiteral<List<String>>(){}.getRawType()).build();
    }
}

