/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.pipelineprocessor.functions.strings;

import com.google.common.collect.ImmutableList;
import com.google.common.primitives.Ints;
import org.apache.commons.lang3.StringUtils;
import org.graylog.plugins.pipelineprocessor.EvaluationContext;
import org.graylog.plugins.pipelineprocessor.ast.functions.AbstractFunction;
import org.graylog.plugins.pipelineprocessor.ast.functions.FunctionArgs;
import org.graylog.plugins.pipelineprocessor.ast.functions.FunctionDescriptor;
import org.graylog.plugins.pipelineprocessor.ast.functions.ParameterDescriptor;

public class Abbreviate
extends AbstractFunction<String> {
    public static final String NAME = "abbreviate";
    private static final String VALUE = "value";
    private static final String WIDTH = "width";
    private final ParameterDescriptor<String, String> valueParam = ParameterDescriptor.string("value").description("The string to abbreviate").build();
    private final ParameterDescriptor<Long, Long> widthParam = ParameterDescriptor.integer("width").description("The maximum number of characters including the '...' (at least 4)").build();

    @Override
    public String evaluate(FunctionArgs args, EvaluationContext context) {
        String value = this.valueParam.required(args, context);
        Long required = this.widthParam.required(args, context);
        if (required == null) {
            return null;
        }
        Long maxWidth = Math.max(required, 4L);
        return StringUtils.abbreviate((String)value, (int)Ints.saturatedCast((long)maxWidth));
    }

    @Override
    public FunctionDescriptor<String> descriptor() {
        ImmutableList.Builder params = ImmutableList.builder();
        params.add((Object[])new ParameterDescriptor[0]);
        return FunctionDescriptor.builder().name(NAME).returnType(String.class).params((ImmutableList<ParameterDescriptor>)ImmutableList.of(this.valueParam, this.widthParam)).description("Abbreviates a string by appending '...' to fit into a maximum amount of characters").build();
    }
}

