/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.views.search.engine;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import com.google.common.graph.Traverser;
import java.util.Collections;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.inject.Inject;
import org.graylog.plugins.views.search.Filter;
import org.graylog.plugins.views.search.Query;
import org.graylog.plugins.views.search.QueryMetadata;
import org.graylog.plugins.views.search.SearchType;
import org.graylog.plugins.views.search.elasticsearch.ElasticsearchQueryString;
import org.graylog.plugins.views.search.elasticsearch.QueryParam;
import org.graylog.plugins.views.search.elasticsearch.QueryStringParser;
import org.graylog.plugins.views.search.filter.QueryStringFilter;

public class QueryParser {
    private final QueryStringParser queryStringParser;

    @Inject
    public QueryParser(QueryStringParser queryStringParser) {
        this.queryStringParser = queryStringParser;
    }

    public QueryMetadata parse(Query query) {
        Preconditions.checkArgument((boolean)(query.query() instanceof ElasticsearchQueryString));
        String mainQueryString = query.query().queryString();
        Stream<String> queryStringStreams = Stream.concat(Stream.of(mainQueryString), query.searchTypes().stream().flatMap(this::queryStringsFromSearchType));
        return queryStringStreams.map(this.queryStringParser::parse).reduce(QueryMetadata.builder().build(), (meta1, meta2) -> QueryMetadata.builder().usedParameters((Set<QueryParam>)Sets.union(meta1.usedParameters(), meta2.usedParameters())).build());
    }

    private Stream<String> queryStringsFromSearchType(SearchType searchType) {
        return Stream.concat(searchType.query().filter(query -> query instanceof ElasticsearchQueryString).map(query -> query.queryString()).map(Stream::of).orElse(Stream.empty()), this.queryStringsFromFilter(searchType.filter()).stream());
    }

    private Set<String> queryStringsFromFilter(Filter entry) {
        if (entry != null) {
            Traverser filterTraverser = Traverser.forTree(filter -> (Set)MoreObjects.firstNonNull(filter.filters(), Collections.emptySet()));
            return StreamSupport.stream(filterTraverser.breadthFirst((Object)entry).spliterator(), false).filter(filter -> filter instanceof QueryStringFilter).map(queryStringFilter -> ((QueryStringFilter)queryStringFilter).query()).filter(Objects::nonNull).collect(Collectors.toSet());
        }
        return Collections.emptySet();
    }
}

