/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.views.search.rest;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.Map;
import javax.inject.Inject;
import javax.validation.constraints.NotNull;
import javax.ws.rs.GET;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import one.util.streamex.StreamEx;
import org.apache.shiro.authz.annotation.RequiresAuthentication;
import org.graylog.plugins.views.search.Parameter;
import org.graylog.plugins.views.search.Query;
import org.graylog.plugins.views.search.Search;
import org.graylog.plugins.views.search.SearchDomain;
import org.graylog.plugins.views.search.SearchMetadata;
import org.graylog.plugins.views.search.engine.QueryEngine;
import org.graylog.plugins.views.search.permissions.SearchUser;
import org.graylog.plugins.views.search.rest.SearchDTO;
import org.graylog2.audit.jersey.NoAuditEvent;
import org.graylog2.plugin.rest.PluginRestResource;
import org.graylog2.shared.rest.resources.RestResource;

@Api(value="Search/Metadata", tags={"cloud"})
@Path(value="/views/search/metadata")
@Produces(value={"application/json"})
@RequiresAuthentication
public class SearchMetadataResource
extends RestResource
implements PluginRestResource {
    private final QueryEngine queryEngine;
    private final SearchDomain searchDomain;

    @Inject
    public SearchMetadataResource(QueryEngine queryEngine, SearchDomain searchDomain) {
        this.queryEngine = queryEngine;
        this.searchDomain = searchDomain;
    }

    @GET
    @ApiOperation(value="Metadata for the given Search object", notes="Used for already persisted search objects")
    @Path(value="{searchId}")
    public SearchMetadata metadata(@ApiParam(value="searchId") @PathParam(value="searchId") String searchId, @Context SearchUser searchUser) {
        SearchDTO search = this.searchDomain.getForUser(searchId, searchUser).map(SearchDTO::fromSearch).orElseThrow(() -> new NotFoundException("Search with id " + searchId + " does not exist"));
        return this.metadataForObject(search);
    }

    @POST
    @ApiOperation(value="Metadata for the posted Search object", notes="Intended for search objects that aren't yet persisted (e.g. for validation or interactive purposes)")
    @NoAuditEvent(value="Only returning metadata for given search, not changing any data")
    public SearchMetadata metadataForObject(@ApiParam @NotNull(message="Search body is mandatory") @NotNull(message="Search body is mandatory") SearchDTO searchDTO) {
        if (searchDTO == null) {
            throw new IllegalArgumentException("Search must not be null.");
        }
        Search search = searchDTO.toSearch();
        Map queryMetadatas = StreamEx.of(search.queries()).toMap(Query::id, query -> this.queryEngine.parse(search, (Query)query));
        return SearchMetadata.create(queryMetadatas, (ImmutableMap<String, Parameter>)Maps.uniqueIndex(search.parameters(), Parameter::name));
    }
}

