/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.views.search.validation;

import java.io.IOException;
import org.apache.lucene.queryparser.classic.CharStream;
import org.graylog.plugins.views.search.validation.TokenLineCounter;

public class LineCountingCharStream
implements CharStream {
    private final CharStream delegate;
    private final TokenLineCounter tokenLineCounter;

    public LineCountingCharStream(CharStream delegate) {
        this.delegate = delegate;
        this.tokenLineCounter = new TokenLineCounter(delegate);
    }

    public char BeginToken() throws IOException {
        try {
            char oneChar = this.delegate.BeginToken();
            this.tokenLineCounter.beginToken(oneChar);
            return oneChar;
        }
        catch (IOException e) {
            if (e.getMessage().equals("read past eof")) {
                this.tokenLineCounter.incrementTokenStartPositionOnError();
            }
            throw e;
        }
    }

    public char readChar() throws IOException {
        char oneChar = this.delegate.readChar();
        this.tokenLineCounter.processChar(oneChar);
        return oneChar;
    }

    @Deprecated
    public int getColumn() {
        return this.delegate.getColumn();
    }

    @Deprecated
    public int getLine() {
        return this.delegate.getLine();
    }

    public int getBeginLine() {
        return this.tokenLineCounter.getBeginLine();
    }

    public int getBeginColumn() {
        return this.tokenLineCounter.getBeginColumn();
    }

    public int getEndLine() {
        return this.tokenLineCounter.getEndLine();
    }

    public int getEndColumn() {
        return this.tokenLineCounter.getEndColumn();
    }

    public void backup(int amount) {
        this.delegate.backup(amount);
    }

    public String GetImage() {
        return this.delegate.GetImage();
    }

    public char[] GetSuffix(int len) {
        return this.delegate.GetSuffix(len);
    }

    public void Done() {
        this.delegate.Done();
    }
}

