/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.views.search.validation;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.auto.value.AutoValue;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import org.graylog.plugins.views.search.validation.AutoValue_ValidationMessage;
import org.graylog.plugins.views.search.validation.ValidationType;
import org.graylog2.shared.utilities.ExceptionUtils;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@AutoValue
public abstract class ValidationMessage {
    private static final Pattern regexPosition = Pattern.compile(".*at line (\\d+), column (\\d+).", 40);

    @JsonProperty
    @Nullable
    public abstract Integer beginLine();

    @JsonProperty
    @Nullable
    public abstract Integer beginColumn();

    @JsonProperty
    @Nullable
    public abstract Integer endLine();

    @JsonProperty
    @Nullable
    public abstract Integer endColumn();

    @JsonProperty
    public abstract String errorMessage();

    @Nullable
    @JsonProperty
    public abstract String relatedProperty();

    @JsonProperty
    public abstract ValidationType validationType();

    public static ValidationMessage fromException(Exception exception) {
        String input = exception.toString();
        Builder errorBuilder = ValidationMessage.builder(ValidationType.QUERY_PARSING_ERROR);
        String rootCause = ValidationMessage.getErrorMessage(exception);
        errorBuilder.errorMessage(String.format(Locale.ROOT, "Cannot parse query, cause: %s", rootCause));
        Matcher positionMatcher = regexPosition.matcher(input);
        if (positionMatcher.find()) {
            errorBuilder.beginLine(1);
            errorBuilder.beginColumn(0);
            errorBuilder.endLine(Integer.parseInt(positionMatcher.group(1)));
            errorBuilder.endColumn(Integer.parseInt(positionMatcher.group(2)));
        }
        return errorBuilder.build();
    }

    private static String getErrorMessage(Exception exception) {
        String rootCause = ExceptionUtils.getRootCauseMessage(exception);
        if (rootCause.contains("Encountered \"<EOF>\"")) {
            return "incomplete query, query ended unexpectedly";
        }
        return rootCause;
    }

    public static Builder builder(ValidationType validationType) {
        return new AutoValue_ValidationMessage.Builder().validationType(validationType);
    }

    @AutoValue.Builder
    public static abstract class Builder {
        public abstract Builder beginLine(int var1);

        public abstract Builder beginColumn(int var1);

        public abstract Builder endLine(int var1);

        public abstract Builder endColumn(int var1);

        public abstract Builder errorMessage(String var1);

        public abstract Builder relatedProperty(String var1);

        public abstract Builder validationType(ValidationType var1);

        public abstract ValidationMessage build();
    }
}

