/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.scheduler;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.auto.value.AutoValue;
import java.util.Optional;
import javax.annotation.Nullable;
import org.graylog.scheduler.AutoValue_JobTriggerUpdate;
import org.graylog.scheduler.JobTriggerData;
import org.graylog.scheduler.JobTriggerDto;
import org.graylog.scheduler.JobTriggerStatus;
import org.joda.time.DateTime;

@JsonDeserialize(builder=Builder.class)
@AutoValue
public abstract class JobTriggerUpdate {
    public abstract Optional<DateTime> nextTime();

    public abstract Optional<JobTriggerData> data();

    public abstract Optional<JobTriggerStatus> status();

    public static JobTriggerUpdate withNextTime(DateTime nextTime) {
        return JobTriggerUpdate.builder().nextTime(nextTime).build();
    }

    public static JobTriggerUpdate withoutNextTime() {
        return JobTriggerUpdate.builder().nextTime(null).build();
    }

    public static JobTriggerUpdate withError(JobTriggerDto trigger) {
        return JobTriggerUpdate.builder().nextTime(trigger.nextTime()).status(JobTriggerStatus.ERROR).build();
    }

    public static JobTriggerUpdate withNextTimeAndData(DateTime nextTime, JobTriggerData data) {
        return JobTriggerUpdate.builder().nextTime(nextTime).data(data).build();
    }

    public static Builder builder() {
        return Builder.create();
    }

    public abstract Builder toBuilder();

    @AutoValue.Builder
    public static abstract class Builder {
        @JsonCreator
        public static Builder create() {
            return new AutoValue_JobTriggerUpdate.Builder();
        }

        public abstract Builder nextTime(@Nullable DateTime var1);

        public abstract Builder data(@Nullable JobTriggerData var1);

        public abstract Builder status(@Nullable JobTriggerStatus var1);

        public abstract JobTriggerUpdate build();
    }
}

