/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.scheduler.clock;

import com.google.common.util.concurrent.Uninterruptibles;
import java.util.concurrent.TimeUnit;
import org.graylog.scheduler.clock.JobSchedulerClock;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;

public class JobSchedulerSystemClock
implements JobSchedulerClock {
    public static final JobSchedulerSystemClock INSTANCE = new JobSchedulerSystemClock();

    @Override
    public DateTime nowUTC() {
        return this.now(DateTimeZone.UTC);
    }

    @Override
    public DateTime now(DateTimeZone zone) {
        return DateTime.now((DateTimeZone)zone);
    }

    @Override
    public void sleep(long duration, TimeUnit unit) throws InterruptedException {
        Thread.sleep(unit.toMillis(duration));
    }

    @Override
    public void sleepUninterruptibly(long duration, TimeUnit unit) {
        Uninterruptibles.sleepUninterruptibly((long)duration, (TimeUnit)unit);
    }
}

